<?php
/**
 * Class that operate on table 'tbl_subordinate'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblSubordinateMySqlDAO implements TblSubordinateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblSubordinateMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_subordinate WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_subordinate';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_subordinate ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblSubordinate primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_subordinate WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSubordinateMySql tblSubordinate
 	 */
	public function insert($tblSubordinate){
		$sql = 'INSERT INTO tbl_subordinate (superior_id, subordinate_id, department, status) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSubordinate->superiorId);
		$sqlQuery->setNumber($tblSubordinate->subordinateId);
		$sqlQuery->set($tblSubordinate->department);
		$sqlQuery->set($tblSubordinate->status);

		$id = $this->executeInsert($sqlQuery);	
		$tblSubordinate->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSubordinateMySql tblSubordinate
 	 */
	public function update($tblSubordinate){
		$sql = 'UPDATE tbl_subordinate SET superior_id = ?, subordinate_id = ?, department = ?, status = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSubordinate->superiorId);
		$sqlQuery->setNumber($tblSubordinate->subordinateId);
		$sqlQuery->set($tblSubordinate->department);
		$sqlQuery->set($tblSubordinate->status);

		$sqlQuery->setNumber($tblSubordinate->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_subordinate';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySuperiorId($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE superior_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubordinateId($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE subordinate_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartment($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE department = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySuperiorId($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE superior_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubordinateId($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE subordinate_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartment($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE department = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblSubordinateMySql 
	 */
	protected function readRow($row){
		$tblSubordinate = new TblSubordinate();
		
		$tblSubordinate->id = $row['id'];
		$tblSubordinate->superiorId = $row['superior_id'];
		$tblSubordinate->subordinateId = $row['subordinate_id'];
		$tblSubordinate->department = $row['department'];
		$tblSubordinate->status = $row['status'];

		return $tblSubordinate;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblSubordinateMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>