<?php
/**
 * Class that operate on table 'tbl_leave_credits'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblLeaveCreditsMySqlDAO implements TblLeaveCreditsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveCreditsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_credits';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_credits ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCredit primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_credits WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCreditsMySql tblLeaveCredit
 	 */
	public function insert($tblLeaveCredit){
		$sql = 'INSERT INTO tbl_leave_credits (user_id, code, SL, VL, SIL, total_credits) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCredit->userId);
		$sqlQuery->set($tblLeaveCredit->code);
		$sqlQuery->set($tblLeaveCredit->sL);
		$sqlQuery->set($tblLeaveCredit->vL);
		$sqlQuery->set($tblLeaveCredit->sIL);
		$sqlQuery->set($tblLeaveCredit->totalCredits);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeaveCredit->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCreditsMySql tblLeaveCredit
 	 */
	public function update($tblLeaveCredit){
		$sql = 'UPDATE tbl_leave_credits SET user_id = ?, code = ?, SL = ?, VL = ?, SIL = ?, total_credits = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCredit->userId);
		$sqlQuery->set($tblLeaveCredit->code);
		$sqlQuery->set($tblLeaveCredit->sL);
		$sqlQuery->set($tblLeaveCredit->vL);
		$sqlQuery->set($tblLeaveCredit->sIL);
		$sqlQuery->set($tblLeaveCredit->totalCredits);

		$sqlQuery->setNumber($tblLeaveCredit->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_credits';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCode($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySL($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE SL = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVL($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE VL = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySIL($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE SIL = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotalCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCode($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySL($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE SL = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVL($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE VL = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySIL($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE SIL = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotalCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveCreditsMySql 
	 */
	protected function readRow($row){
		$tblLeaveCredit = new TblLeaveCredit();
		
		$tblLeaveCredit->id = $row['id'];
		$tblLeaveCredit->userId = $row['user_id'];
		$tblLeaveCredit->code = $row['code'];
		$tblLeaveCredit->sL = $row['SL'];
		$tblLeaveCredit->vL = $row['VL'];
		$tblLeaveCredit->sIL = $row['SIL'];
		$tblLeaveCredit->totalCredits = $row['total_credits'];

		return $tblLeaveCredit;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveCreditsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>