<?php
/**
 * Class that operate on table 'tbl_employment'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblEmploymentMySqlDAO implements TblEmploymentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblEmploymentMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_employment WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_employment';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_employment ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblEmployment primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_employment WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEmploymentMySql tblEmployment
 	 */
	public function insert($tblEmployment){
		$sql = 'INSERT INTO tbl_employment (user_id, date_hired, employment_status, regularization, vacation, sick, leave, lastDay, employeeStatus, remarks) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEmployment->userId);
		$sqlQuery->set($tblEmployment->dateHired);
		$sqlQuery->set($tblEmployment->employmentStatus);
		$sqlQuery->set($tblEmployment->regularization);
		$sqlQuery->setNumber($tblEmployment->vacation);
		$sqlQuery->setNumber($tblEmployment->sick);
		$sqlQuery->setNumber($tblEmployment->leave);
		$sqlQuery->set($tblEmployment->lastDay);
		$sqlQuery->set($tblEmployment->employeeStatus);
		$sqlQuery->set($tblEmployment->remarks);

		$id = $this->executeInsert($sqlQuery);	
		$tblEmployment->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEmploymentMySql tblEmployment
 	 */
	public function update($tblEmployment){
		$sql = 'UPDATE tbl_employment SET user_id = ?, date_hired = ?, employment_status = ?, regularization = ?, vacation = ?, sick = ?, leave = ?, lastDay = ?, employeeStatus = ?, remarks = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEmployment->userId);
		$sqlQuery->set($tblEmployment->dateHired);
		$sqlQuery->set($tblEmployment->employmentStatus);
		$sqlQuery->set($tblEmployment->regularization);
		$sqlQuery->setNumber($tblEmployment->vacation);
		$sqlQuery->setNumber($tblEmployment->sick);
		$sqlQuery->setNumber($tblEmployment->leave);
		$sqlQuery->set($tblEmployment->lastDay);
		$sqlQuery->set($tblEmployment->employeeStatus);
		$sqlQuery->set($tblEmployment->remarks);

		$sqlQuery->setNumber($tblEmployment->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_employment';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_employment WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateHired($value){
		$sql = 'SELECT * FROM tbl_employment WHERE date_hired = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmploymentStatus($value){
		$sql = 'SELECT * FROM tbl_employment WHERE employment_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRegularization($value){
		$sql = 'SELECT * FROM tbl_employment WHERE regularization = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVacation($value){
		$sql = 'SELECT * FROM tbl_employment WHERE vacation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySick($value){
		$sql = 'SELECT * FROM tbl_employment WHERE sick = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLeave($value){
		$sql = 'SELECT * FROM tbl_employment WHERE leave = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLastDay($value){
		$sql = 'SELECT * FROM tbl_employment WHERE lastDay = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmployeeStatus($value){
		$sql = 'SELECT * FROM tbl_employment WHERE employeeStatus = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRemarks($value){
		$sql = 'SELECT * FROM tbl_employment WHERE remarks = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_employment WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateHired($value){
		$sql = 'DELETE FROM tbl_employment WHERE date_hired = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmploymentStatus($value){
		$sql = 'DELETE FROM tbl_employment WHERE employment_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRegularization($value){
		$sql = 'DELETE FROM tbl_employment WHERE regularization = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVacation($value){
		$sql = 'DELETE FROM tbl_employment WHERE vacation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySick($value){
		$sql = 'DELETE FROM tbl_employment WHERE sick = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLeave($value){
		$sql = 'DELETE FROM tbl_employment WHERE leave = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLastDay($value){
		$sql = 'DELETE FROM tbl_employment WHERE lastDay = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmployeeStatus($value){
		$sql = 'DELETE FROM tbl_employment WHERE employeeStatus = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRemarks($value){
		$sql = 'DELETE FROM tbl_employment WHERE remarks = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblEmploymentMySql 
	 */
	protected function readRow($row){
		$tblEmployment = new TblEmployment();
		
		$tblEmployment->id = $row['id'];
		$tblEmployment->userId = $row['user_id'];
		$tblEmployment->dateHired = $row['date_hired'];
		$tblEmployment->employmentStatus = $row['employment_status'];
		$tblEmployment->regularization = $row['regularization'];
		$tblEmployment->vacation = $row['vacation'];
		$tblEmployment->sick = $row['sick'];
		$tblEmployment->leave = $row['leave'];
		$tblEmployment->lastDay = $row['lastDay'];
		$tblEmployment->employeeStatus = $row['employeeStatus'];
		$tblEmployment->remarks = $row['remarks'];

		return $tblEmployment;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblEmploymentMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>