<?php
/**
 * Class that operate on table 'tbl_chat_access'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblChatAccessMySqlDAO implements TblChatAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblChatAccessMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_chat_access WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_chat_access';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_chat_access ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblChatAcces primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_chat_access WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblChatAccessMySql tblChatAcces
 	 */
	public function insert($tblChatAcces){
		$sql = 'INSERT INTO tbl_chat_access (group_id, member_id, date_added) VALUES (?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblChatAcces->groupId);
		$sqlQuery->setNumber($tblChatAcces->memberId);
		$sqlQuery->set($tblChatAcces->dateAdded);

		$id = $this->executeInsert($sqlQuery);	
		$tblChatAcces->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblChatAccessMySql tblChatAcces
 	 */
	public function update($tblChatAcces){
		$sql = 'UPDATE tbl_chat_access SET group_id = ?, member_id = ?, date_added = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblChatAcces->groupId);
		$sqlQuery->setNumber($tblChatAcces->memberId);
		$sqlQuery->set($tblChatAcces->dateAdded);

		$sqlQuery->setNumber($tblChatAcces->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_chat_access';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByGroupId($value){
		$sql = 'SELECT * FROM tbl_chat_access WHERE group_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMemberId($value){
		$sql = 'SELECT * FROM tbl_chat_access WHERE member_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateAdded($value){
		$sql = 'SELECT * FROM tbl_chat_access WHERE date_added = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByGroupId($value){
		$sql = 'DELETE FROM tbl_chat_access WHERE group_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMemberId($value){
		$sql = 'DELETE FROM tbl_chat_access WHERE member_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateAdded($value){
		$sql = 'DELETE FROM tbl_chat_access WHERE date_added = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblChatAccessMySql 
	 */
	protected function readRow($row){
		$tblChatAcces = new TblChatAcces();
		
		$tblChatAcces->id = $row['id'];
		$tblChatAcces->groupId = $row['group_id'];
		$tblChatAcces->memberId = $row['member_id'];
		$tblChatAcces->dateAdded = $row['date_added'];

		return $tblChatAcces;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblChatAccessMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>