<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblNotificationDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblNotification 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblNotification primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNotification tblNotification
 	 */
	public function insert($tblNotification);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNotification tblNotification
 	 */
	public function update($tblNotification);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByMessage($value);

	public function queryByDate($value);


	public function deleteByUserId($value);

	public function deleteByMessage($value);

	public function deleteByDate($value);


}
?>