<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblDprTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDprTransaction 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDprTransaction primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDprTransaction tblDprTransaction
 	 */
	public function insert($tblDprTransaction);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDprTransaction tblDprTransaction
 	 */
	public function update($tblDprTransaction);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByDate($value);

	public function queryByDateSubmit($value);

	public function queryByMajorAccomplishment($value);

	public function queryByIssueConcern($value);

	public function queryByStatus($value);

	public function queryByPostedId($value);

	public function queryByTranspoReimburse($value);


	public function deleteByUserId($value);

	public function deleteByDate($value);

	public function deleteByDateSubmit($value);

	public function deleteByMajorAccomplishment($value);

	public function deleteByIssueConcern($value);

	public function deleteByStatus($value);

	public function deleteByPostedId($value);

	public function deleteByTranspoReimburse($value);


}
?>