<style>
.fc-day:hover{
	background: #ececec;
	cursor: pointer;
	transition: .3s;
	color: #fff;
}
.fc-event { 
    height: 100%;
    font-size: 10px!important; 
    padding: 3px!important;
    word-wrap: break-word!important;
    /*position: ab;*/
}
.fc-title:hover{
	cursor:pointer;
}
.showWorkingType{
	font-size: 18px; 
	padding: 10px; 
	background: #5bc0de; 
	color: #fff
}
.showTime{
	font-size: 12px;
	padding: 7px 11px;
	background: #f1f1f1;
	border-left: 1px solid #ddd;
	border-right: 1px solid #ddd;
	color: #585858;
}
.showRemarks{
	font-size: 15px;
	padding: 20px;
	background: #fff;
	border: 1px solid #ddd;
	height: 380px;
	overflow-y: scroll;
}
</style>
<div class="box-standard">
	<div class="row">
		<div class="col-lg-12">
			<div id="calendar"></div>
		</div>
	</div>
</div>

<form method="post" id="formAddEvent">
	<div id="sampleModal" class="modal fade" role="dialog">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"><i class="pe-7s-date pe-lg"></i> Add Event</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group">
						<div class="col-lg-12">
							Date: 
							<input type="text" class="form-control" readonly name="date">
						</div>
					</div>
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Working Type: 
							<select type="text" name="workingType" data-live-search="true" class="form-control selectpicker" required="">
								<option selected disabled></option>
								<option value="regular">Regular</option>
								<option value="holiday">Holiday</option>
								<option value="restday">Restday</option>
							</select>
						</div>
					</div>
					<div class="form-group holiday" style="display: none">
						<div class="col-lg-12 mt-10">
							Holiday: 
							<select type="text" name="holiday" data-live-search="true" class="form-control selectpicker">
							</select>
						</div>
					</div>
					<div class="form-group fromTime" style="display: none">
						<div class="col-lg-6 mt-10">
							From: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="fromTime" type="text" value="8:00 AM" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
						<div class="col-lg-6 mt-10">
							To: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="toTime" type="text" value="6:00 PM" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
					</div>
					<!-- <div class="form-group toTime" style="display: none">
					</div> -->
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Remarks: 
							<textarea class="form-control" rows="6" name="remarks"></textarea>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">Save</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>

		</div>
	</div>
</form>

<form method="post" id="formUpdateEvent">
	<div id="updateModal" class="modal fade" role="dialog">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"><i class="pe-7s-date pe-lg"></i> Update Event</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group">
						<div class="col-lg-12">
							Date: 
							<input type="text" class="form-control" readonly name="date">
						</div>
					</div>
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Working Type: 
							<select type="text" name="workingType" data-live-search="true" class="form-control selectpicker" required="">
								<option selected disabled></option>
								<option value="regular">Regular</option>
								<option value="holiday">Holiday</option>
								<option value="restday">Restday</option>
							</select>
						</div>
					</div>
					<div class="form-group holiday" style="display: none">
						<div class="col-lg-12 mt-10">
							Holiday: 
							<?php $holiday = DAOFactory::getTblHolidayDAO()->queryAll();?>
							<select type="text" name="holiday" data-live-search="true" class="form-control selectpicker">
							<?php foreach ($holiday as $key => $value): ?>
								<option value="<?=$value->id?>"><?=$value->holiday?></option>
							<?php endforeach?>
							</select>
						</div>
					</div>
					<div class="form-group fromTime" style="display: none">
						<div class="col-lg-6 mt-10">
							From: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="fromTime" type="text" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
						<div class="col-lg-6 mt-10">
							To: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="toTime" type="text" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
					</div>
					<!-- <div class="form-group toTime" style="display: none">
					</div> -->
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Remarks: 
							<textarea class="form-control" rows="6" name="remarks"></textarea>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">Save</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>

		</div>
	</div>
</form>

<div id="showInfo" class="modal fade" role="dialog">
	<div class="modal-dialog modal-lg">
	<div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title"><i class="pe-7s-date pe-lg"></i> <span class="titleDate"></span></h4>
		</div>
		<div class="modal-body">
			<div class="showWorkingType"></div>
			<div class="showTime"></div>
			<div class="showRemarks"></div>
		</div>
	</div>

	</div>
</div>
<script>
	$(function(){


		$('textarea[name="remarks"]').ckeditor();
		
		$('#formAddEvent').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to save this event?',function(){
				$.post(URL+'calendar/addEvent',form)
				.done(function(returnData){

					location.reload();
				})
				return false;
			})
			return false;
			
		})
		$('#formUpdateEvent').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to update this event?',function(){
				$.post(URL+'calendar/updateEvent',form)
				.done(function(returnData){
					alert(returnData);
					location.reload();
				})
				return false;
			})
			return false;
			
		})
		$('select[name="workingType"]').change(function(){
		 	var val = $(this).val();
			if(val=='regular'){
				$('.totalHours').show();
				$('.holiday').hide();
				$('.fromTime').show();
				$('.toTime').show();
			} else if(val=='holiday'){
				$('.totalHours').hide();
				$('.holiday').show();
				$('.fromTime').show();
				$('.toTime').show();
			} else{
				$('.holiday').hide();
				$('.fromTime').hide();
				$('.toTime').hide();

			}
		})
		$('#calendar').fullCalendar({
			dayClick: function(date) {
				var date = date.format();
				selectDate(date)
				getHoliday();
				
			},
			events: [
				<?php $data = DAOFactory::getTblWorkingCalendarDAO()->queryAll();?>
				<?php foreach ($data as $key => $value): $wdayTitle = ($value->workingType == "regular") ? strtoupper($value->workingType).' WORKING DAY' : strtoupper($value->workingType);?>
					<?php if($value->workingType != "restday"): ?>
					{
						id: 3,
						title:"<?=$wdayTitle?>",
						start:"<?=$value->workingDate?>",
						color:"#21bc5a"
					},
					{
						id: 2,
						title:"<?=date('h:i A',strtotime($value->fromTime)).' - '.date('h:i A',strtotime($value->toTime))?>",
						start:"<?=$value->workingDate?>",
						color:"#d9534f"
					},
						
						<?php if(!empty($value->remarks)): ?>
						{
							id: 1,
							title:"Click for more info...",
							start:"<?=$value->workingDate?>",
							color:"#5bc0de"
						},
						<?php endif;?>
					<?php else:?>
					{
						id: 3,
						title:"<?=$wdayTitle?>",
						start:"<?=$value->workingDate?>",
						color:"#21bc5a"
					},
						<?php if(!empty($value->remarks)): ?>
						{
							id: 1,
							title:"Click for more info...",
							start:"<?=$value->workingDate?>",
							color:"#5bc0de"
						},
						<?php endif;?>
					<?php endif;?>
				<?php endforeach;?>
					
			],
			eventOrder: "-id",
			eventRender: function(event, element) {
               element.bind('click', function() {
               	var date = event.start;

               	 getEvent(date.format());
               });
               // alert(event);
            }
    	})
	})
	function getHoliday(){
		$.post(URL+'setup/showHoliday')
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data, function(key,a){
				append += '<option value="'+a.id+'">'+a.holiday+'</option>'
			})
			$('#formAddEvent').find('select[name="holiday"]').html(append);
			$('#formAddEvent').find('select[name="holiday"]').selectpicker('refresh');

		})
	}
	function selectDate(date){
			// getHoliday();
		$.post(URL+'calendar/getEventByDate',{"date":date})
		.done(function(returnData){
			if(returnData=='[]'){
				$('#formAddEvent').find('input[name="date"]').val(date);
				$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
			} else {
				var data = $.parseJSON(returnData);
				// alert(data[0].holidayId)
				$('#formUpdateEvent').find('input[name="date"]').val(date);
				$('#formUpdateEvent').find('select[name="holiday"]').val(data[0].holidayId).trigger('change');
				$('#formUpdateEvent').find('select[name="workingType"]').val(data[0].workingType).trigger('change');
				$('#formUpdateEvent').find('input[name="fromTime"]').val(data[0].fromTime);
				$('#formUpdateEvent').find('input[name="toTime"]').val(data[0].toTime);
				$('#formUpdateEvent').find('textarea[name="remarks"]').val(data[0].remarks);
				if(data[0].workingType=='regular'){
					$('.totalHours').show();
					$('.holiday').hide();
					$('.fromTime').show();
					$('.toTime').show();
				} else if(data[0].workingType=='holiday'){
					$('.totalHours').hide();
					$('.holiday').show();
					$('.fromTime').show();
					$('.toTime').show();
				} else{
					$('.holiday').hide();
					$('.fromTime').hide(); 
					$('.toTime').hide();

				}
				$('#updateModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
			}

		})
	}
	function getEvent(date){
		$.post(URL+'calendar/getEventByDateHoliday',{'date':date})
		.done(function(returnData){			
			var data = $.parseJSON(returnData);
			if(data[0].remarks!=''){
				var monthNames = ["","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
				var wdayTitle = (data[0].working_type == "regular") ? data[0].working_type.toUpperCase()+' WORKING DAY' : ((data[0].working_type == "holiday") ? data[0].working_type.toUpperCase()+' ('+data[0].holiday+')' : data[0].working_type.toUpperCase());
				var wTimeTitle = (data[0].working_type == "regular" || data[0].working_type == "holiday") ? tConvert(data[0].fromTime)+' - '+tConvert(data[0].toTime) : '';
				var month = monthNames[Number(date.split('-')[1]).toString()];
				var day = date.split('-')[2];
				var year = date.split('-')[0];
				$('.titleDate').html(month+' '+day+', '+year);
				$('.showWorkingType').html(wdayTitle);
				$('.showTime').html(wTimeTitle);
				$('.showRemarks').html(data[0].remarks);
				$('#showInfo').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
			}
		})
	}
	function tConvert(time) {
	  // Check correct time format and split into components
	  time = time.toString ().match (/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

	  if (time.length > 1) { // If time format correct
	    time = time.slice (1);  // Remove full string match value
	    time[5] = +time[0] < 12 ? ' AM' : ' PM'; // Set AM/PM
	    time[0] = +time[0] % 12 || 12; // Adjust hours
	  }
	  return time.join (''); // return adjusted time or original string
	}
</script>