$(function(){
	show();
	countTable('setup/countLeaveType','LVT-','#formLeaveType','input[name="leave_type_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formLeaveType').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveLeaveType', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#leave_type_table').on('click','.updateLeaveType',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('leavetypeId');
		var leave_type_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var leave_type = $(this).closest('tr').find('td:nth-child(2)').html();
		var description = $(this).closest('tr').find('td:nth-child(3)').html();
		var status = $(this).closest('tr').find('td:nth-child(4)').html();

		$('#updateLeaveType').find('input[name="leave_type_id"]').val(id);
		$('#updateLeaveType').find('input[name="leave_type_no"]').val(leave_type_no);
		$('#updateLeaveType').find('input[name="leave_type"]').val(leave_type);
		$('#updateLeaveType').find('input[name="description"]').val(description);

		if(status == 'enabled'){
			$('#updateLeaveType').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateLeaveType').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateLeaveType').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateLeaveType', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#leave_type_table');
	$.post(URL+'setup/showLeaveType')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.leaveTypeNo+"</td>"+
							"<td>"+a.leaveType+"</td>"+
							"<td>"+a.description+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a leavetypeId='"+a.id+"' class='updateLeaveType btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.leavetypeData').html(append);
		$('#leave_type_table').DataTable({
			    "ordering": false
		});
	})
}