$(function(){
	show();
	countTable('setup/countCompany','CMP-','#formCompany','input[name="company_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formCompany').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveCompany', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Added!');
					setTimeout(function(){
						location.reload();
					}, 1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#company_table').on('click', '.updateCompany', function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('companyId');
		var company_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var company_name = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();
		$('#updateCompany').find('input[name="company_id"]').val(id);
		$('#updateCompany').find('input[name="company_no"]').val(company_no);
		$('#updateCompany').find('input[name="company_name"]').val(company_name);
		if(status == 'enabled'){
			$('#updateCompany').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateCompany').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateCompany').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?', function(){
			$.post(URL+'setup/updateCompany', data)
				.done(function(returnData){
					if(returnData == ''){
						toastr.success('Data Successfully Updated!');
						setTimeout(function(){
							location.reload();
						},1000)
					}else{
						toastr.error(returnData);
						$('#saveAlertModal').modal('hide');
					}
				})
			return false;	
		})
		return false;	
		
	})
});
function show(){
	tableLoader('#company_table');
	$.post(URL+'setup/showCompany')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data,function(key,a){
			append += "<tr>"+
						"<td>"+a.companyNo+"</td>"+
						"<td>"+a.company+"</td>"+
						"<td>"+a.status+"</td>"+
						"<td>"+
							"<a companyId='"+a.id+"' class='updateCompany btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
						"</td>"+
					"</tr>";
		})
		$('.companyData').html(append);
		$('#company_table').DataTable({
		    "ordering": false
		});
	})
}