<?php
	if(!($this->data)):
?>
		<input type="hidden" name="counts" class="toRemove" value="20"/>
		<input type="hidden" name="page" value="1"/>
<?php
		echo 'No database found!';
		exit;
	endif;
	$lists = $this->listAll;
	$pages = count($lists) / $_POST['counts'];
	
	$array = explode('.',$pages);
	$pages = isset($array[1]) ? $array[0] + 1 : $array[0];
	
?>
<div class="row">
	<div class="col-xs-3 form-group">
		<div class="input-group">
			<input type="number" name="counts" class="form-control" value="<?= $_POST['counts'] ?>"/>
			<span class="input-group-addon">/<?= count($lists) ?></span>
		</div>
	</div>
	<div class="col-xs-2 form-group">
		<select name="page" class="form-control">
			<?php for($n = 1; $n <= $pages; $n++): ?>
				<option <?= $n == $_POST['page'] ? 'selected' : '' ?>><?=$n?></option>
			<?php endfor; ?>
		</select>
	</div>
	
	<div class="col-xs-12">
		<table class="table table-bordered">
			<tr>
				<th>Databases Name</th>
				<th>Account Email</th>
				<th class="text-center"></th>
			</tr>
			<?php $i=1;?>
			<?php if($this->data):?>
				<?php foreach($this->data as $each): ?>
					<tr>
						<td><?= UB_MAIN_NAME.$each['database_name'] ?></td>
						<td><?= $each['account_name'] ?></td>
						<td class="text-right">
							<button type="button" class="btn btn-success-standard showClientLogs" title="See Logs" data-toggle="modal" data-target="#modalShowClientLogs">
								<i class="pe-7s-leaf pe-lg"></i>
							</button>
						</td>
						<td class="hidden"></td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</table>
	</div>
</div>

<div class="modal fade" id="modalShowClientLogs" role="dialog">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">
					<i class="pe-7s-close pe-2x"></i>
				</button>
				<h4>
					<span class="text-600 text-muted"></span>
				</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group col-xs-4">
						<input type="text" class="form-control datepicker" name="datefrom" placeholder="Date from.." />
					</div>
					<div class="form-group col-xs-4">
						<input type="text" class="form-control datepicker" name="dateto" placeholder="Date to.." />
					</div>
					<div class="form-group col-xs-2">
						<button class="btn btn-success-standard searchDateLog" type="button">
							<i class="pe-7s-search"></i>
						</button>
					</div>
				</div>
				<div class="clientLogsContent">
				</div>	
			</div>
		</div>
	</div>
</div>
<script>
	$(function(){
		
		loadDatepicker();
		
		$('.showClientLogs').click(function(){
	
			var dbName = $(this).closest('tr').children('td:first').html();
			var body = $(this);
			$('#modalShowClientLogs').find('.modal-header').find('span').html(dbName);
			countSummary(dbName,body);
			$.post('<?=URL?>report/clientLogContent',{'dbName':dbName})
			.done(function(returnData)
			{
				$('.clientLogsContent').html(returnData);
			});
			
		});
		
		$('.searchDateLog').click(function(){
			var dbName = $('#modalShowClientLogs').find('.modal-header').find('span').html();
			var datefrom = $(this).closest('.row').find('input[name="datefrom"]').val();
			var dateto = $(this).closest('.row').find('input[name="dateto"]').val();
			
			$.post('<?=URL?>report/clientLogContent',{'dbName':dbName,'datefrom':datefrom,'dateto':dateto})
			.done(function(returnData)
			{
				$('.clientLogsContent').html(returnData);
			});
		});
	});
	
	function countSummary(dbName,body)
	{
		body.closest('tr').children('td:last').removeClass('hidden');
		$.post('<?=URL?>report/countSummary',{'dbName':dbName})
		.done(function(returnData){
			var changeCont = ' <span class="badge text-muted text-600">'+returnData+'</span>';
			body.closest('tr').children('td:last').html(changeCont);
		})
	}
</script>