$(function(){
	show();
	seriesLastNum('tbl_employee_status','EMP-','#formEmployee','input[name="employee_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formEmployee').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveEmployee', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#employee_status_table').on('click','.updateEmployeeStatus',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('employeeStatusId');
		var employee_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var employee = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateEmployee').find('input[name="employee_id"]').val(id);
		$('#updateEmployee').find('input[name="employee_no"]').val(employee_no);
		$('#updateEmployee').find('input[name="employee"]').val(employee);

		if(status == 'enabled'){
			$('#updateEmployee').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateEmployee').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateEmployee').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateEmployeeStatus', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#employee_status_table');
	$.post(URL+'setup/showEmployeeStatus')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.empstatusNo+"</td>"+
							"<td>"+a.empStatus+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a employeeStatusId='"+a.id+"' class='updateEmployeeStatus btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";
		});
		$('.employeeStatusData').html(append);
		$('#employee_status_table').DataTable({
			    "ordering": false
		});
	})
}