<?php
/**
 * Class that operate on table 'tbl_nbt_approve'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblNbtApproveMySqlDAO implements TblNbtApproveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtApproveMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_approve';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_approve ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtApprove primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtApproveMySql tblNbtApprove
 	 */
	public function insert($tblNbtApprove){
		$sql = 'INSERT INTO tbl_nbt_approve (subsync_id, subdomain, user_id, approver_id, from_date, to_date, date_approve, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtApprove->subsyncId);
		$sqlQuery->setNumber($tblNbtApprove->subdomain);
		$sqlQuery->setNumber($tblNbtApprove->userId);
		$sqlQuery->setNumber($tblNbtApprove->approverId);
		$sqlQuery->set($tblNbtApprove->fromDate);
		$sqlQuery->set($tblNbtApprove->toDate);
		$sqlQuery->set($tblNbtApprove->dateApprove);
		$sqlQuery->setNumber($tblNbtApprove->createdBy);
		$sqlQuery->setNumber($tblNbtApprove->modifiedBy);
		$sqlQuery->set($tblNbtApprove->dateCreated);
		$sqlQuery->set($tblNbtApprove->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtApprove->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtApproveMySql tblNbtApprove
 	 */
	public function update($tblNbtApprove){
		$sql = 'UPDATE tbl_nbt_approve SET subsync_id = ?, subdomain = ?, user_id = ?, approver_id = ?, from_date = ?, to_date = ?, date_approve = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtApprove->subsyncId);
		$sqlQuery->setNumber($tblNbtApprove->subdomain);
		$sqlQuery->setNumber($tblNbtApprove->userId);
		$sqlQuery->setNumber($tblNbtApprove->approverId);
		$sqlQuery->set($tblNbtApprove->fromDate);
		$sqlQuery->set($tblNbtApprove->toDate);
		$sqlQuery->set($tblNbtApprove->dateApprove);
		$sqlQuery->setNumber($tblNbtApprove->createdBy);
		$sqlQuery->setNumber($tblNbtApprove->modifiedBy);
		$sqlQuery->set($tblNbtApprove->dateCreated);
		$sqlQuery->set($tblNbtApprove->dateModified);

		$sqlQuery->setNumber($tblNbtApprove->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_approve';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproverId($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromDate($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDate($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateApprove($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE date_approve = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_approve WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproverId($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromDate($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDate($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateApprove($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE date_approve = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_approve WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtApproveMySql 
	 */
	protected function readRow($row){
		$tblNbtApprove = new TblNbtApprove();
		
		$tblNbtApprove->id = $row['id'];
		$tblNbtApprove->subsyncId = $row['subsync_id'];
		$tblNbtApprove->subdomain = $row['subdomain'];
		$tblNbtApprove->userId = $row['user_id'];
		$tblNbtApprove->approverId = $row['approver_id'];
		$tblNbtApprove->fromDate = $row['from_date'];
		$tblNbtApprove->toDate = $row['to_date'];
		$tblNbtApprove->dateApprove = $row['date_approve'];
		$tblNbtApprove->createdBy = $row['created_by'];
		$tblNbtApprove->modifiedBy = $row['modified_by'];
		$tblNbtApprove->dateCreated = $row['date_created'];
		$tblNbtApprove->dateModified = $row['date_modified'];

		return $tblNbtApprove;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtApproveMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>