<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblPlanForTomorrowDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPlanForTomorrow 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPlanForTomorrow primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPlanForTomorrow tblPlanForTomorrow
 	 */
	public function insert($tblPlanForTomorrow);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPlanForTomorrow tblPlanForTomorrow
 	 */
	public function update($tblPlanForTomorrow);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTransId($value);

	public function queryByPlanOutput($value);

	public function queryByBudgetId($value);

	public function queryByTotalHours($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByTransId($value);

	public function deleteByPlanOutput($value);

	public function deleteByBudgetId($value);

	public function deleteByTotalHours($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>