$(function(){
	show();
	countTable('setup/countShift','SFT-','#formShift','input[name="shift_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal('toggle');
	});
	$('#formShift').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveShift', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#shift_table').on('click','.updateShift', function(){
		$('#sampleModalUpdate').modal('toggle');
		var id = $(this).attr('shiftId');
		var shift_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var shift = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();	

		$('#updateShift').find('input[name="shift_id"]').val(id);
		$('#updateShift').find('input[name="shif_no"]').val(shift_no);
		$('#updateShift').find('input[name="shift_name"]').val(shift);

		if(status == 'enabled'){
			$('#updateShift').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateShift').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateShift').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?', function(){
			$.post(URL+'setup/updateShift', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#shift_table');
	$.post(URL+'setup/showShift')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data,function(key,a){
			append += "<tr>"+
						"<td>"+a.shiftNo+"</td>"+
						"<td>"+a.shift+"</td>"+
						"<td>"+a.status+"</td>"+
						"<td>"+
							"<a shiftId='"+a.id+"' class='updateShift btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
						"</td>"+
					"</tr>";
		});

		$('.shiftData').html(append);
		$('#shift_table').DataTable({
		    "ordering": false  
		});
	})
}

