$(function(){
	show();
	countTable('setup/countHoliday','HLD-','#formHoliday','input[name="holiday_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formHoliday').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveHoliday', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#holiday_table').on('click','.updateHoliday',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('holidayId');
		var holiday_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var holiday = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateHoliday').find('input[name="holiday_id"]').val(id);
		$('#updateHoliday').find('input[name="holiday_no"]').val(holiday_no);
		$('#updateHoliday').find('input[name="holiday"]').val(holiday);

		if(status == 'enabled'){
			$('#updateHoliday').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateHoliday').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateHoliday').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateHoliday', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#holiday_table');
	$.post(URL+'setup/showHoliday')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.holidayNo+"</td>"+
							"<td>"+a.holiday+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a holidayId='"+a.id+"' class='updateHoliday btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.holidayData').html(append);
		$('#holiday_table').DataTable({
			    "ordering": false
		});
	})
}