$(function(){
	show();
	countTable('setup/countShift','SFT-','#formShift','input[name="shift_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal('toggle');
	});
	$('#formShift').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveShift', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#time_table').on('click','.updateNBTTime', function(){
		$('#sampleModalUpdate').modal('toggle');
		var id = $(this).attr('timeId');
		var position = $(this).closest('tr').find('td:nth-child(1)').html();
		var time = $(this).closest('tr').find('td:nth-child(2)').html();
		$('input[name=position]').val(position);
		$('input[name=pos_id]').val(id);
		$('input[name=time]').val(time);
	})
	$('#updateNBtTime').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?', function(){
			$.post(URL+'setup/updateNbtTimePerPos', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#time_table');
	$.post(URL+'setup/showNbtTimePerPos')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		var assigned_time = '';
		$.each(data,function(key,a){
			if(a.assigned_time == null){
				assigned_time = '';
			} else{
				assigned_time = a.assigned_time;
			}
			append += "<tr>"+
						"<td>"+a.position+"</td>"+
						"<td>"+assigned_time+"</td>"+
						"<td>"+
							"<a timeId='"+a.id+"' class='updateNBTTime btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
						"</td>"+
					"</tr>";
		});

		$('.timeData').html(append);
		$('#time_table').DataTable({
		    "ordering": false  
		});
	})
}

