$(function(){
	show();
	seriesLastNum('tbl_engagement','ENG-','#formEngagement','input[name="engagement_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formEngagement').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveEngagement', data)
			.done(function(returnData){	
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#engagement_table').on('click','.updateEng',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('engId');
		var eng_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var eng = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateEngagement').find('input[name="engagement_id"]').val(id);
		$('#updateEngagement').find('input[name="engagement_no"]').val(eng_no);
		$('#updateEngagement').find('input[name="engagement"]').val(eng);

		if(status == 'enabled'){
			$('#updateEngagement').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateEngagement').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#engagement_table').on('click','.copyTba',function(){
		var id = $(this).attr('engId');
		var eng_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var eng = $(this).closest('tr').find('td:nth-child(2)').html();
		$('#sampleModalcopyTba').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		$('#sampleModalcopyTba #engName_selected').text(eng_no+' | '+eng);
		$('#copyTba input[name="selected_engagement"]').val(id);
		getEngWithAct();
		getDepartment(id,$('#copyTba').find('select[name="selected_department"]'));
	})
	$('select[name="copy_engagement"]').change(function(){
		var eng = $(this).val();
		getDepartment(eng,$('#copyTba').find('select[name="copy_department"]'));
	})
	$('#updateEngagement').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateEngagement', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
	$('#copyTba').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to copy activities from this data?',function(){
			$.post(URL+'setup/copyTba', data)
			.done(function(returnData){
				toastr.success('Data Successfully Copied!');
				setTimeout(function(){
					location.reload();
				},1000)
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#engagement_table');
	$.post(URL+'setup/showEngagement')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			if(a.check_dept == 'yes'){
				// if(a.check_tba == 'yes'){
				// 	copy = "";
				// } else {
					copy = "<a engId='"+a.id+"' class='copyTba btn-edit-standard'><i class='fa fa-copy'></i></a>";
				// }
			} else {
				copy = "";
			}
			append += "<tr>"+
							"<td>"+a.engagement_no+"</td>"+
							"<td>"+a.engagement+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a engId='"+a.id+"' class='updateEng btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
								copy+
							"</td>"+
						"</tr>";	
		});
		$('.engagementData').html(append);
		$('#engagement_table').DataTable({
			    "ordering": false
		});
	})
}
function getDepartment(eng,select){
	$.post(URL+'setup/showDepartmentPerEng', {'eng':eng})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<option value='"+a.id+"'>"+a.department+"</option>";
		});
		select.html(append);
		select.selectpicker('refresh');
	})
}
function getEngWithAct(){
	$.post(URL+'setup/showEngHasAct')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "<option value='' selected disabled>Select Engagement</option>";
		$.each(data,function(key,a){
			append += "<option value='"+a.id+"'>"+a.engagement+"</option>";
		});
		$('#copyTba').find('select[name="copy_engagement"]').html(append);
		$('#copyTba').find('select[name="copy_engagement"]').selectpicker('refresh');
	})
}