<?php
class Reports_model extends Model
{
	protected $user;

	function __construct()
	{
		parent::__construct();
		$this->user = Session::getSession('user');
	}
	function showSubperDept(){
		$data = DAOFactory::getTblNbtTransactionDAO()->showSubperDept($_POST['subdomain']);
		echo json_encode(self::convert_json($data));
	}
	function generateDpr(){
		$data = DAOFactory::getTblNbtTransactionDAO()->dprReport($_POST['date'], $_POST['subdomain'],$_POST['department']);
		echo json_encode(self::convert_json($data));
	}	
	function generateDpr2(){
		$data = DAOFactory::getTblNbtTransactionDAO()->dprReport2($_POST['date'], $_POST['subdomain']);
		echo json_encode(self::convert_json($data));
	}	
	function generateDprSummary(){
		$data = DAOFactory::getTblNbtTransactionDAO()->dprReportSummary($_POST['id'],$_POST['uid'],$_POST['sub']);
		echo json_encode(self::convert_json($data));
		
	}
	function generateOt(){
		$data = DAOFactory::getTblRequestOtDAO()->oTReport($_POST['subdomain'], $_POST['from'], $_POST['to']);
		echo json_encode(self::convert_json($data));
	}
	function darReport(){
		$data = DAOFactory::getTblNbtTransactionDAO()->darReport($_POST['from'], $_POST['to'], $_POST['subdomain'], $_POST['status']);
		echo json_encode(self::convert_json($data));
		
	}

	function generateLeave(){

		$data = DAOFactory::getTblLeaveRequestDAO()->generateLeave($_POST['subdomain'], $_POST['from'], $_POST['to']);
		echo json_encode(self::convert_json($data));
	}

	function generateManPowerReport(){

		$data = DAOFactory::getTblForecastDAO()->generateManPowerReport($_POST['subdomain'], $_POST['from'], $_POST['to']);
		echo json_encode(self::convert_json($data));
	}

	function generateDashboard(){
		$data = DAOFactory::getTblSubdomainAccountsDAO()->getDashboard($_POST['date']);
		echo json_encode(self::convert_json($data));
	}

	function generateMpSummary(){
		$data = DAOFactory::getTblForecastDAO()->generateMpSummary($_POST['uid'],$_POST['from'],$_POST['to'],$_POST['sub']);
		echo json_encode(self::convert_json($data));
	}

	function getUserPerSubdomain(){

		$data = DAOFactory::getTblUserDAO()->getUserPerSubdomain($_POST['subdomain']);

		echo  json_encode(self::convert_json($data));
		
	}

	function getNbtTrans(){

		$data = DAOFactory::getTblDailyForecastDAO()->getNbtTrans($_POST['user'], $_POST['date']);

		echo json_encode(self::convert_json($data));
	}
	function getEmpStatus(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->queryAll();
		echo json_encode(self::convert_json($data));
	}
	function genUserList(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->genUserList($_POST['subdomain'],$_POST['status']);
		echo json_encode(self::convert_json($data));
	}

	public static function convert_json($dat)
    {
       if (is_string($dat)) {
          return utf8_encode($dat);
       } elseif (is_array($dat)) {
          $ret = [];
          foreach ($dat as $i => $d) $ret[ $i ] = self::convert_json($d);

          return $ret;
       } elseif (is_object($dat)) {
          foreach ($dat as $i => $d) $dat->$i = self::convert_json($d);

          return $dat;
       } else {
          return $dat;
       }
    }

}
?>