<?php
/**
 * Class that operate on table 'tbl_leave_credits_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-04-11 08:51
 */
class TblLeaveCreditsTransactionMySqlDAO implements TblLeaveCreditsTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveCreditsTransactionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCreditsTransaction primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCreditsTransactionMySql tblLeaveCreditsTransaction
 	 */
	public function insert($tblLeaveCreditsTransaction){
		$sql = 'INSERT INTO tbl_leave_credits_transaction (leave_credits_id, old_total_credits, new_total_credits, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCreditsTransaction->leaveCreditsId);
		$sqlQuery->set($tblLeaveCreditsTransaction->oldTotalCredits);
		$sqlQuery->set($tblLeaveCreditsTransaction->newTotalCredits);
		$sqlQuery->setNumber($tblLeaveCreditsTransaction->createdBy);
		$sqlQuery->setNumber($tblLeaveCreditsTransaction->modifiedBy);
		$sqlQuery->set($tblLeaveCreditsTransaction->dateCreated);
		$sqlQuery->set($tblLeaveCreditsTransaction->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeaveCreditsTransaction->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCreditsTransactionMySql tblLeaveCreditsTransaction
 	 */
	public function update($tblLeaveCreditsTransaction){
		$sql = 'UPDATE tbl_leave_credits_transaction SET leave_credits_id = ?, old_total_credits = ?, new_total_credits = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCreditsTransaction->leaveCreditsId);
		$sqlQuery->set($tblLeaveCreditsTransaction->oldTotalCredits);
		$sqlQuery->set($tblLeaveCreditsTransaction->newTotalCredits);
		$sqlQuery->setNumber($tblLeaveCreditsTransaction->createdBy);
		$sqlQuery->setNumber($tblLeaveCreditsTransaction->modifiedBy);
		$sqlQuery->set($tblLeaveCreditsTransaction->dateCreated);
		$sqlQuery->set($tblLeaveCreditsTransaction->dateModified);

		$sqlQuery->setNumber($tblLeaveCreditsTransaction->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_credits_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByLeaveCreditsId($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE leave_credits_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOldTotalCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE old_total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNewTotalCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE new_total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_leave_credits_transaction WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByLeaveCreditsId($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE leave_credits_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOldTotalCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE old_total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNewTotalCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE new_total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_leave_credits_transaction WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveCreditsTransactionMySql 
	 */
	protected function readRow($row){
		$tblLeaveCreditsTransaction = new TblLeaveCreditsTransaction();
		
		$tblLeaveCreditsTransaction->id = $row['id'];
		$tblLeaveCreditsTransaction->leaveCreditsId = $row['leave_credits_id'];
		$tblLeaveCreditsTransaction->oldTotalCredits = $row['old_total_credits'];
		$tblLeaveCreditsTransaction->newTotalCredits = $row['new_total_credits'];
		$tblLeaveCreditsTransaction->createdBy = $row['created_by'];
		$tblLeaveCreditsTransaction->modifiedBy = $row['modified_by'];
		$tblLeaveCreditsTransaction->dateCreated = $row['date_created'];
		$tblLeaveCreditsTransaction->dateModified = $row['date_modified'];

		return $tblLeaveCreditsTransaction;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveCreditsTransactionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>