<?php
/**
 * Class that operate on table 'tbl_employee_directory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblEmployeeDirectoryMySqlDAO implements TblEmployeeDirectoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblEmployeeDirectoryMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_employee_directory';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_employee_directory ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblEmployeeDirectory primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_employee_directory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEmployeeDirectoryMySql tblEmployeeDirectory
 	 */
	public function insert($tblEmployeeDirectory){
		$sql = 'INSERT INTO tbl_employee_directory (user_id, network_id, phone_no, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEmployeeDirectory->userId);
		$sqlQuery->setNumber($tblEmployeeDirectory->networkId);
		$sqlQuery->set($tblEmployeeDirectory->phoneNo);
		$sqlQuery->setNumber($tblEmployeeDirectory->createdBy);
		$sqlQuery->setNumber($tblEmployeeDirectory->modifiedBy);
		$sqlQuery->set($tblEmployeeDirectory->dateCreated);
		$sqlQuery->set($tblEmployeeDirectory->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblEmployeeDirectory->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEmployeeDirectoryMySql tblEmployeeDirectory
 	 */
	public function update($tblEmployeeDirectory){
		$sql = 'UPDATE tbl_employee_directory SET user_id = ?, network_id = ?, phone_no = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEmployeeDirectory->userId);
		$sqlQuery->setNumber($tblEmployeeDirectory->networkId);
		$sqlQuery->set($tblEmployeeDirectory->phoneNo);
		$sqlQuery->setNumber($tblEmployeeDirectory->createdBy);
		$sqlQuery->setNumber($tblEmployeeDirectory->modifiedBy);
		$sqlQuery->set($tblEmployeeDirectory->dateCreated);
		$sqlQuery->set($tblEmployeeDirectory->dateModified);

		$sqlQuery->setNumber($tblEmployeeDirectory->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_employee_directory';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNetworkId($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE network_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPhoneNo($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE phone_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_employee_directory WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNetworkId($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE network_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPhoneNo($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE phone_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_employee_directory WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblEmployeeDirectoryMySql 
	 */
	protected function readRow($row){
		$tblEmployeeDirectory = new TblEmployeeDirectory();
		
		$tblEmployeeDirectory->id = $row['id'];
		$tblEmployeeDirectory->userId = $row['user_id'];
		$tblEmployeeDirectory->networkId = $row['network_id'];
		$tblEmployeeDirectory->phoneNo = $row['phone_no'];
		$tblEmployeeDirectory->createdBy = $row['created_by'];
		$tblEmployeeDirectory->modifiedBy = $row['modified_by'];
		$tblEmployeeDirectory->dateCreated = $row['date_created'];
		$tblEmployeeDirectory->dateModified = $row['date_modified'];

		return $tblEmployeeDirectory;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblEmployeeDirectoryMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>