<?php
/**
 * Class that operate on table 'tbl_project_activities'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblProjectActivitiesMySqlDAO implements TblProjectActivitiesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblProjectActivitiesMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_project_activities WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_project_activities';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_project_activities ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblProjectActivitie primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_project_activities WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblProjectActivitiesMySql tblProjectActivitie
 	 */
	public function insert($tblProjectActivitie){
		$sql = 'INSERT INTO tbl_project_activities (act_number, project_id, act_id, grp_id) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblProjectActivitie->actNumber);
		$sqlQuery->setNumber($tblProjectActivitie->projectId);
		$sqlQuery->setNumber($tblProjectActivitie->actId);
		$sqlQuery->setNumber($tblProjectActivitie->grpId);

		$id = $this->executeInsert($sqlQuery);	
		$tblProjectActivitie->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblProjectActivitiesMySql tblProjectActivitie
 	 */
	public function update($tblProjectActivitie){
		$sql = 'UPDATE tbl_project_activities SET act_number = ?, project_id = ?, act_id = ?, grp_id = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblProjectActivitie->actNumber);
		$sqlQuery->setNumber($tblProjectActivitie->projectId);
		$sqlQuery->setNumber($tblProjectActivitie->actId);
		$sqlQuery->setNumber($tblProjectActivitie->grpId);

		$sqlQuery->setNumber($tblProjectActivitie->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_project_activities';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByActNumber($value){
		$sql = 'SELECT * FROM tbl_project_activities WHERE act_number = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProjectId($value){
		$sql = 'SELECT * FROM tbl_project_activities WHERE project_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActId($value){
		$sql = 'SELECT * FROM tbl_project_activities WHERE act_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGrpId($value){
		$sql = 'SELECT * FROM tbl_project_activities WHERE grp_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByActNumber($value){
		$sql = 'DELETE FROM tbl_project_activities WHERE act_number = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProjectId($value){
		$sql = 'DELETE FROM tbl_project_activities WHERE project_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActId($value){
		$sql = 'DELETE FROM tbl_project_activities WHERE act_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGrpId($value){
		$sql = 'DELETE FROM tbl_project_activities WHERE grp_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblProjectActivitiesMySql 
	 */
	protected function readRow($row){
		$tblProjectActivitie = new TblProjectActivitie();
		
		$tblProjectActivitie->id = $row['id'];
		$tblProjectActivitie->actNumber = $row['act_number'];
		$tblProjectActivitie->projectId = $row['project_id'];
		$tblProjectActivitie->actId = $row['act_id'];
		$tblProjectActivitie->grpId = $row['grp_id'];

		return $tblProjectActivitie;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblProjectActivitiesMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>