<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblTeamMemberDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblTeamMember 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblTeamMember primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTeamMember tblTeamMember
 	 */
	public function insert($tblTeamMember);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTeamMember tblTeamMember
 	 */
	public function update($tblTeamMember);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTeamId($value);

	public function queryByUserId($value);

	public function queryByType($value);


	public function deleteByTeamId($value);

	public function deleteByUserId($value);

	public function deleteByType($value);


}
?>