<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblRequestOtDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblRequestOt 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblRequestOt primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRequestOt tblRequestOt
 	 */
	public function insert($tblRequestOt);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRequestOt tblRequestOt
 	 */
	public function update($tblRequestOt);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByClient($value);

	public function queryByExpectedOutput($value);

	public function queryByFromHours($value);

	public function queryByToHours($value);

	public function queryByEstimatedHours($value);

	public function queryByReason($value);

	public function queryByStatus($value);

	public function queryByDateRequested($value);

	public function queryByDateOvertime($value);

	public function queryByApproveId($value);


	public function deleteByUserId($value);

	public function deleteByClient($value);

	public function deleteByExpectedOutput($value);

	public function deleteByFromHours($value);

	public function deleteByToHours($value);

	public function deleteByEstimatedHours($value);

	public function deleteByReason($value);

	public function deleteByStatus($value);

	public function deleteByDateRequested($value);

	public function deleteByDateOvertime($value);

	public function deleteByApproveId($value);


}
?>