<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblLeaveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblLeave 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblLeave primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeave tblLeave
 	 */
	public function insert($tblLeave);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeave tblLeave
 	 */
	public function update($tblLeave);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByActivity($value);

	public function queryByTimeStart($value);

	public function queryByTimeEnd($value);

	public function queryByTimeSpent($value);

	public function queryByHourCode($value);

	public function queryByLineProperty($value);

	public function queryByPlannedOutput($value);

	public function queryByCategory($value);

	public function queryByActualOutput($value);

	public function queryByDate($value);

	public function queryByApproveDate($value);

	public function queryByStatus($value);

	public function queryByApproveId($value);


	public function deleteByUserId($value);

	public function deleteByActivity($value);

	public function deleteByTimeStart($value);

	public function deleteByTimeEnd($value);

	public function deleteByTimeSpent($value);

	public function deleteByHourCode($value);

	public function deleteByLineProperty($value);

	public function deleteByPlannedOutput($value);

	public function deleteByCategory($value);

	public function deleteByActualOutput($value);

	public function deleteByDate($value);

	public function deleteByApproveDate($value);

	public function deleteByStatus($value);

	public function deleteByApproveId($value);


}
?>