$(function(){
	show();
	seriesLastNum('tbl_position','POS-','#formPosition','input[name="pos_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});

	$('#formPosition').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?',function(){
			$.post(URL + 'setup/savePosition', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
		});
		return false;
	});
	$('#position_table').on('click','.updatePosition',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('positionId');
		var pos_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var position = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updatePosition').find('input[name="pos_id"]').val(id);
		$('#updatePosition').find('input[name="pos_no"]').val(pos_no);
		$('#updatePosition').find('input[name="position"]').val(position);

		if(status == 'enabled'){
			$('#updatePosition').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updatePosition').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updatePosition').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updatePosition', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#position_table');
	$.post(URL+'setup/showPosition')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.positionNo+"</td>"+
							"<td>"+a.position+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a positionId='"+a.id+"' class='updatePosition btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.positionData').html(append);
		$('#position_table').DataTable({
			    "ordering": false
		});
	})
}