<?php
/**
 * Class that operate on table 'tbl_user_info_other'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-14 02:30
 */
class TblUserInfoOtherMySqlDAO implements TblUserInfoOtherDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUserInfoOtherMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_user_info_other';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_user_info_other ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUserInfoOther primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_user_info_other WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserInfoOtherMySql tblUserInfoOther
 	 */
	public function insert($tblUserInfoOther){
		$sql = 'INSERT INTO tbl_user_info_other (user_id, bdate, gender, phone_no, mobile_no, current_address, current_city, current_province, permanent_address, permanent_city, permanent_province, civil_status, contact_person, contact_number, contact_address, sss, tin, philhealth, hdmf, blood_type_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserInfoOther->userId);
		$sqlQuery->set($tblUserInfoOther->bdate);
		$sqlQuery->set($tblUserInfoOther->gender);
		$sqlQuery->set($tblUserInfoOther->phoneNo);
		$sqlQuery->set($tblUserInfoOther->mobileNo);
		$sqlQuery->set($tblUserInfoOther->currentAddress);
		$sqlQuery->setNumber($tblUserInfoOther->currentCity);
		$sqlQuery->setNumber($tblUserInfoOther->currentProvince);
		$sqlQuery->set($tblUserInfoOther->permanentAddress);
		$sqlQuery->setNumber($tblUserInfoOther->permanentCity);
		$sqlQuery->setNumber($tblUserInfoOther->permanentProvince);
		$sqlQuery->set($tblUserInfoOther->civilStatus);
		$sqlQuery->set($tblUserInfoOther->contactPerson);
		$sqlQuery->set($tblUserInfoOther->contactNumber);
		$sqlQuery->set($tblUserInfoOther->contactAddress);
		$sqlQuery->set($tblUserInfoOther->sss);
		$sqlQuery->set($tblUserInfoOther->tin);
		$sqlQuery->set($tblUserInfoOther->philhealth);
		$sqlQuery->set($tblUserInfoOther->hdmf);
		$sqlQuery->setNumber($tblUserInfoOther->bloodTypeId);
		$sqlQuery->setNumber($tblUserInfoOther->createdBy);
		$sqlQuery->setNumber($tblUserInfoOther->modifiedBy);
		$sqlQuery->set($tblUserInfoOther->dateCreated);
		$sqlQuery->set($tblUserInfoOther->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblUserInfoOther->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserInfoOtherMySql tblUserInfoOther
 	 */
	public function update($tblUserInfoOther){
		$sql = 'UPDATE tbl_user_info_other SET user_id = ?, bdate = ?, gender = ?, phone_no = ?, mobile_no = ?, current_address = ?, current_city = ?, current_province = ?, permanent_address = ?, permanent_city = ?, permanent_province = ?, civil_status = ?, contact_person = ?, contact_number = ?, contact_address = ?, sss = ?, tin = ?, philhealth = ?, hdmf = ?, blood_type_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserInfoOther->userId);
		$sqlQuery->set($tblUserInfoOther->bdate);
		$sqlQuery->set($tblUserInfoOther->gender);
		$sqlQuery->set($tblUserInfoOther->phoneNo);
		$sqlQuery->set($tblUserInfoOther->mobileNo);
		$sqlQuery->set($tblUserInfoOther->currentAddress);
		$sqlQuery->setNumber($tblUserInfoOther->currentCity);
		$sqlQuery->setNumber($tblUserInfoOther->currentProvince);
		$sqlQuery->set($tblUserInfoOther->permanentAddress);
		$sqlQuery->setNumber($tblUserInfoOther->permanentCity);
		$sqlQuery->setNumber($tblUserInfoOther->permanentProvince);
		$sqlQuery->set($tblUserInfoOther->civilStatus);
		$sqlQuery->set($tblUserInfoOther->contactPerson);
		$sqlQuery->set($tblUserInfoOther->contactNumber);
		$sqlQuery->set($tblUserInfoOther->contactAddress);
		$sqlQuery->set($tblUserInfoOther->sss);
		$sqlQuery->set($tblUserInfoOther->tin);
		$sqlQuery->set($tblUserInfoOther->philhealth);
		$sqlQuery->set($tblUserInfoOther->hdmf);
		$sqlQuery->setNumber($tblUserInfoOther->bloodTypeId);
		$sqlQuery->setNumber($tblUserInfoOther->createdBy);
		$sqlQuery->setNumber($tblUserInfoOther->modifiedBy);
		$sqlQuery->set($tblUserInfoOther->dateCreated);
		$sqlQuery->set($tblUserInfoOther->dateModified);

		$sqlQuery->setNumber($tblUserInfoOther->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_user_info_other';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBdate($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE bdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGender($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE gender = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPhoneNo($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE phone_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMobileNo($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE mobile_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCurrentAddress($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE current_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCurrentCity($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE current_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCurrentProvince($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE current_province = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPermanentAddress($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE permanent_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPermanentCity($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE permanent_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPermanentProvince($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE permanent_province = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCivilStatus($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE civil_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContactPerson($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE contact_person = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContactNumber($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE contact_number = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContactAddress($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE contact_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySss($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE sss = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTin($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE tin = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPhilhealth($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE philhealth = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHdmf($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE hdmf = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBloodTypeId($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE blood_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_user_info_other WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBdate($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE bdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGender($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE gender = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPhoneNo($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE phone_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMobileNo($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE mobile_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCurrentAddress($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE current_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCurrentCity($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE current_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCurrentProvince($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE current_province = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPermanentAddress($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE permanent_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPermanentCity($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE permanent_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPermanentProvince($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE permanent_province = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCivilStatus($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE civil_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContactPerson($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE contact_person = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContactNumber($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE contact_number = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContactAddress($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE contact_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySss($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE sss = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTin($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE tin = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPhilhealth($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE philhealth = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHdmf($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE hdmf = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBloodTypeId($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE blood_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_user_info_other WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUserInfoOtherMySql 
	 */
	protected function readRow($row){
		$tblUserInfoOther = new TblUserInfoOther();
		
		$tblUserInfoOther->id = $row['id'];
		$tblUserInfoOther->userId = $row['user_id'];
		$tblUserInfoOther->bdate = $row['bdate'];
		$tblUserInfoOther->gender = $row['gender'];
		$tblUserInfoOther->phoneNo = $row['phone_no'];
		$tblUserInfoOther->mobileNo = $row['mobile_no'];
		$tblUserInfoOther->currentAddress = $row['current_address'];
		$tblUserInfoOther->currentCity = $row['current_city'];
		$tblUserInfoOther->currentProvince = $row['current_province'];
		$tblUserInfoOther->permanentAddress = $row['permanent_address'];
		$tblUserInfoOther->permanentCity = $row['permanent_city'];
		$tblUserInfoOther->permanentProvince = $row['permanent_province'];
		$tblUserInfoOther->civilStatus = $row['civil_status'];
		$tblUserInfoOther->contactPerson = $row['contact_person'];
		$tblUserInfoOther->contactNumber = $row['contact_number'];
		$tblUserInfoOther->contactAddress = $row['contact_address'];
		$tblUserInfoOther->sss = $row['sss'];
		$tblUserInfoOther->tin = $row['tin'];
		$tblUserInfoOther->philhealth = $row['philhealth'];
		$tblUserInfoOther->hdmf = $row['hdmf'];
		$tblUserInfoOther->bloodTypeId = $row['blood_type_id'];
		$tblUserInfoOther->createdBy = $row['created_by'];
		$tblUserInfoOther->modifiedBy = $row['modified_by'];
		$tblUserInfoOther->dateCreated = $row['date_created'];
		$tblUserInfoOther->dateModified = $row['date_modified'];

		return $tblUserInfoOther;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUserInfoOtherMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>