<?php
/**
 * Class that operate on table 'tbl_nbt_hours_spent'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblNbtHoursSpentMySqlDAO implements TblNbtHoursSpentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtHoursSpentMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtHoursSpent primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtHoursSpentMySql tblNbtHoursSpent
 	 */
	public function insert($tblNbtHoursSpent){
		$sql = 'INSERT INTO tbl_nbt_hours_spent (subsync_id, subdomain, nbt_transaction_id, daily_forecast_id, hours_spent, hour_code, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtHoursSpent->subsyncId);
		$sqlQuery->setNumber($tblNbtHoursSpent->subdomain);
		$sqlQuery->setNumber($tblNbtHoursSpent->nbtTransactionId);
		$sqlQuery->setNumber($tblNbtHoursSpent->dailyForecastId);
		$sqlQuery->set($tblNbtHoursSpent->hoursSpent);
		$sqlQuery->set($tblNbtHoursSpent->hourCode);
		$sqlQuery->setNumber($tblNbtHoursSpent->createdBy);
		$sqlQuery->setNumber($tblNbtHoursSpent->modifiedBy);
		$sqlQuery->set($tblNbtHoursSpent->dateCreated);
		$sqlQuery->set($tblNbtHoursSpent->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtHoursSpent->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtHoursSpentMySql tblNbtHoursSpent
 	 */
	public function update($tblNbtHoursSpent){
		$sql = 'UPDATE tbl_nbt_hours_spent SET subsync_id = ?, subdomain = ?, nbt_transaction_id = ?, daily_forecast_id = ?, hours_spent = ?, hour_code = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtHoursSpent->subsyncId);
		$sqlQuery->setNumber($tblNbtHoursSpent->subdomain);
		$sqlQuery->setNumber($tblNbtHoursSpent->nbtTransactionId);
		$sqlQuery->setNumber($tblNbtHoursSpent->dailyForecastId);
		$sqlQuery->set($tblNbtHoursSpent->hoursSpent);
		$sqlQuery->set($tblNbtHoursSpent->hourCode);
		$sqlQuery->setNumber($tblNbtHoursSpent->createdBy);
		$sqlQuery->setNumber($tblNbtHoursSpent->modifiedBy);
		$sqlQuery->set($tblNbtHoursSpent->dateCreated);
		$sqlQuery->set($tblNbtHoursSpent->dateModified);

		$sqlQuery->setNumber($tblNbtHoursSpent->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_hours_spent';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNbtTransactionId($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE nbt_transaction_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDailyForecastId($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE daily_forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHoursSpent($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE hours_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourCode($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_hours_spent WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNbtTransactionId($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE nbt_transaction_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDailyForecastId($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE daily_forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHoursSpent($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE hours_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourCode($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_hours_spent WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtHoursSpentMySql 
	 */
	protected function readRow($row){
		$tblNbtHoursSpent = new TblNbtHoursSpent();
		
		$tblNbtHoursSpent->id = $row['id'];
		$tblNbtHoursSpent->subsyncId = $row['subsync_id'];
		$tblNbtHoursSpent->subdomain = $row['subdomain'];
		$tblNbtHoursSpent->nbtTransactionId = $row['nbt_transaction_id'];
		$tblNbtHoursSpent->dailyForecastId = $row['daily_forecast_id'];
		$tblNbtHoursSpent->hoursSpent = $row['hours_spent'];
		$tblNbtHoursSpent->hourCode = $row['hour_code'];
		$tblNbtHoursSpent->createdBy = $row['created_by'];
		$tblNbtHoursSpent->modifiedBy = $row['modified_by'];
		$tblNbtHoursSpent->dateCreated = $row['date_created'];
		$tblNbtHoursSpent->dateModified = $row['date_modified'];

		return $tblNbtHoursSpent;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtHoursSpentMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>