<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-01-12 03:15
 */
interface TblSubordinateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblSubordinate 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblSubordinate primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSubordinate tblSubordinate
 	 */
	public function insert($tblSubordinate);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSubordinate tblSubordinate
 	 */
	public function update($tblSubordinate);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySuperiorId($value);

	public function queryBySubordinateId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySuperiorId($value);

	public function deleteBySubordinateId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>