<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblPbsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPbs 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPb primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPbs tblPb
 	 */
	public function insert($tblPb);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPbs tblPb
 	 */
	public function update($tblPb);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByUserId($value);

	public function queryByClientId($value);

	public function queryByPbsDate($value);

	public function queryByGreetClient($value);

	public function queryByClientGreet($value);

	public function queryByProvideCommunication($value);

	public function queryByReplyCommunication($value);

	public function queryByExerciseHumility($value);

	public function queryByContentName($value);

	public function queryByEmailAddress($value);

	public function queryBySubject($value);

	public function queryByMessage($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByUserId($value);

	public function deleteByClientId($value);

	public function deleteByPbsDate($value);

	public function deleteByGreetClient($value);

	public function deleteByClientGreet($value);

	public function deleteByProvideCommunication($value);

	public function deleteByReplyCommunication($value);

	public function deleteByExerciseHumility($value);

	public function deleteByContentName($value);

	public function deleteByEmailAddress($value);

	public function deleteBySubject($value);

	public function deleteByMessage($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>