$(function(){
	show();
	countTable('setup/countDepartment','DN-','#formDept','input[name="dept_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formDept').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveDepartment', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#department_table').on('click','.updateDept', function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('deptId');
		var dept_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var dept_name = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateDept').find('input[name="dept_id"]').val(id);
		$('#updateDept').find('input[name="dept_no"]').val(dept_no);
		$('#updateDept').find('input[name="dept_name"]').val(dept_name);

		if(status == 'enabled'){
			$('#updateDept').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateDept').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateDept').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?', function(){
			$.post(URL+'setup/updateDept', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#department_table');
	$.post(URL+'setup/showDepartment')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data,function(key,a){
			append += "<tr>"+
						"<td>"+a.deptNo+"</td>"+
						"<td>"+a.department+"</td>"+
						"<td>"+a.status+"</td>"+
						"<td>"+
							"<a deptId='"+a.id+"' class='updateDept btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
						"</td>"+
					"</tr>";
		});

		$('.departmentData').html(append);
		$('#department_table').DataTable({
		    "ordering": false  
		});
	})
}

