<?php 
require '_AWSSES/index.php';

use Aws\Ses\SesClient;
use Aws\S3\S3Client;

class Aws{

	static function client($type){
		$creds = array( 
		    'version'=> 'latest',     
		    'region' => ($type == 'ses' ? REGION_US : ($type == 's3' ? REGION_AP : '')),
			'verify' => 'false',
			'credentials' => [
				'key' => 'AKIAJC7DIEU5WE7WRLOQ',
				'secret' => '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',
			],
		);
		return ($type == 'ses' ? SesClient::factory($creds) : ($type == 's3' ? S3Client::factory($creds) : '')) ;
	}
	
	static function email($sender,$to,$subject,$body)
	{
		// require '_AWSSES/index.php';
		$client = self::client('ses');

		$request = array();
		$request['Source'] = $sender;
		$request['Destination']['ToAddresses'] = $to;

		$request['Message']['Subject']['Data'] = $subject;
		$request['Message']['Body']['Html']['Data'] = $body;

		try {
			 $result = $client->sendEmail($request);
			 $messageId = $result->get('MessageId');
			  echo("Email sent! Message ID: $messageId"."\n");

		} catch (Exception $e) {
			 echo("The email was not sent. Error message: ");
			 echo($e->getMessage()."\n");
		}
	}

	static function uploadFileS3($file,$keyname) {
		// require '_AWSSES/index.php';
		$clientS3 = self::client('s3');

		try {
			$result = $clientS3->putObject(array(
				'Bucket'       	 => BUCKETNAME, //global variable found in libs/Server.php
				'Key'            => $keyname, //S3 directory(file name & extension required)  *no spaces required request/otie.xlsx
				'SourceFile'   	 => $file, //tmp or content
				'ACL'            => 'public-read',
			));
			
			return $result['ObjectURL'];
		} catch (S3Exception $e) {
			echo $e->getMessage() . "\n";
		}
	}

	static function downloadFileS3($s3File){
		// require '_AWSSES/index.php';
		$clientS3 = self::client('s3');

		$keyname = $s3File['directory'].$s3File['name'];

		try {
			$result = $clientS3->getObject(array(
				'Bucket'		=> BUCKETNAME,
				'Key'			=> $keyname,
			));

			header("Content-Disposition: attachment; filename=".$s3File['name']);
		    header("Content-Type: ".$s3File['type']);
		    header("Content-Length: ".$s3File['size']);
		    ob_clean();
		    flush();	

		    echo $result['Body'];

		} catch (S3Exception $e) {
		    echo $e->getMessage() . "\n";
		}
	}
	static function getUrlS3($keyname){
		// require '_AWSSES/index.php';
		$clientS3 = self::client('s3');

		try {
			$result = $clientS3->getObjectUrl(BUCKETNAME,$keyname);
			  return $result;

		} catch (S3Exception $e) {
		 	 echo $e->getMessage() . "\n";
		}
	}

}

//// database 
/* 

	file_name
	file_type
	file_size
	file_directory

*/

?>