<?php
/**
 * Class that operate on table 'tbl_department_per_company'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblDepartmentPerCompanyMySqlDAO implements TblDepartmentPerCompanyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDepartmentPerCompanyMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_department_per_company';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_department_per_company ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDepartmentPerCompany primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_department_per_company WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDepartmentPerCompanyMySql tblDepartmentPerCompany
 	 */
	public function insert($tblDepartmentPerCompany){
		$sql = 'INSERT INTO tbl_department_per_company (company_id, department_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDepartmentPerCompany->companyId);
		$sqlQuery->setNumber($tblDepartmentPerCompany->departmentId);
		$sqlQuery->setNumber($tblDepartmentPerCompany->createdBy);
		$sqlQuery->setNumber($tblDepartmentPerCompany->modifiedBy);
		$sqlQuery->set($tblDepartmentPerCompany->dateCreated);
		$sqlQuery->set($tblDepartmentPerCompany->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblDepartmentPerCompany->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDepartmentPerCompanyMySql tblDepartmentPerCompany
 	 */
	public function update($tblDepartmentPerCompany){
		$sql = 'UPDATE tbl_department_per_company SET company_id = ?, department_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDepartmentPerCompany->companyId);
		$sqlQuery->setNumber($tblDepartmentPerCompany->departmentId);
		$sqlQuery->setNumber($tblDepartmentPerCompany->createdBy);
		$sqlQuery->setNumber($tblDepartmentPerCompany->modifiedBy);
		$sqlQuery->set($tblDepartmentPerCompany->dateCreated);
		$sqlQuery->set($tblDepartmentPerCompany->dateModified);

		$sqlQuery->setNumber($tblDepartmentPerCompany->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_department_per_company';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByCompanyId($value){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE company_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartmentId($value){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE department_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_department_per_company WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByCompanyId($value){
		$sql = 'DELETE FROM tbl_department_per_company WHERE company_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartmentId($value){
		$sql = 'DELETE FROM tbl_department_per_company WHERE department_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_department_per_company WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_department_per_company WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_department_per_company WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_department_per_company WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDepartmentPerCompanyMySql 
	 */
	protected function readRow($row){
		$tblDepartmentPerCompany = new TblDepartmentPerCompany();
		
		$tblDepartmentPerCompany->id = $row['id'];
		$tblDepartmentPerCompany->companyId = $row['company_id'];
		$tblDepartmentPerCompany->departmentId = $row['department_id'];
		$tblDepartmentPerCompany->createdBy = $row['created_by'];
		$tblDepartmentPerCompany->modifiedBy = $row['modified_by'];
		$tblDepartmentPerCompany->dateCreated = $row['date_created'];
		$tblDepartmentPerCompany->dateModified = $row['date_modified'];

		return $tblDepartmentPerCompany;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDepartmentPerCompanyMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>