<div class="box-standard">
	<div class="row">
		<div class="col-lg-6 col-sm-6">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> Requested/Approved Engagement</div>
		</div>
		<div class="col-lg-6 col-sm-6 text-right">
			<button class="btn btn-success sample"><i class="pe-7s-search pe-lg"></i> Filter</button>
		</div>
	</div>
</div>
<form method="post" id="formGenerateMapEngagement">
	
	<div id="sampleModal" class="modal fade" role="dialog">
		<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"><i class="pe-7s-search pe-lg"></i> Filter</h4>
			</div>
			<div class="modal-body">
				<div class="form-group">
					Status: 
						<select data-live-search="true" class="form-control selectpicker" name="status" id="status" required="">
							<!-- <option disabled selected>Select Status</option> -->
							<option value="%%">All</option>
							<option value="posted">Posted</option>
							<option value="Saved">To be posted</option>
						</select>
				</div>
				<div class="form-group">
					Subdomain: 
						<select data-live-search="true" class="form-control selectpicker" name="subdomain" id="subdomain" required="">
						</select>
				</div>
			</div>
			<div class="modal-footer">
				<button type="submit" id="btnSave" class="btn btn-success btn-block">Generate</button>
			</div>
		</div>

		</div>
	</div>
</form>
<form method="post" id="formUpdateEngagement">
	
	<div id="sampleModalUpdate" class="modal fade" role="dialog">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"> Update Engagement</h4>
			</div>
			<div class="modal-body" style="padding: 20px 30px;">
				<div class="row mt-10">
			      	<div class="col-lg-6">
						<input type="hidden" class="form-control" name="id" id="id">
						<input type="hidden" class="form-control" name="subdomain" id="subdomain">
						<div class="form-group row">
							<label class="control-label col-sm-4" for="client">Client:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="client" id="client" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="engagement">Engagement Name:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="engagement" id="engagement" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="start_date">Start Date:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control datepicker" name="start_date" id="start_date" required>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="end_date">Estimated End:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control datepicker" name="end_date" id="end_date" required>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="status">Engagement Status:</label>
							<div class="col-sm-8">
							    <select class="form-control selectpicker" required name="status" id="status" data-live-search="true">
									<option selected disabled></option>
									<option value="In Process">In Process</option>
									<option value="Finished">Finished</option>
									<option value="Withdrawn">Withdrawn</option>
								</select>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="budget">Overall Budget Hours:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="overall_budget_hours" id="overall_budget_hours" readonly>
							</div>
						</div>
			      	</div>
			      	<div class="col-lg-6">
						<div class="form-group row">
							<label class="control-label col-sm-4" for="referred_by">Referred By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="referred_by" id="referred_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="closed_by">Closed By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="closed_by" id="closed_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="initiated_by">Initiated By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="initiated_by" id="initiated_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="managed_by">Managed By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="managed_by" id="managed_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="type">Type:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="type" id="type" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="contract_price">Contract Price:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="contract_price" id="contract_price" readonly>
							</div>
						</div>
			      	</div>
			      	<div class="col-lg-12">
		      			<label>Budget Per Position:</label>
				      	<div class="table-responsive">
							<table class="table table-striped table-standard" id="budgetPerPositionTable">
								<thead>
									<tr class="positionHead">
										
									</tr>
								</thead>
								<tbody>
									<tr class="positionBody">
										
									</tr>
								</tbody>
							</table>
						</div>
			      	</div>
		      	</div>
			</div>
			<div class="modal-footer">
				<button type="submit" id="btnSave" class="btn btn-success">Update</button>
				<button type="button" class="btn" data-dismiss="modal">Close</button>
			</div>
		</div>

		</div>
	</div>
</form>
<form method="post" id="formUpdateEngagementNew" class="form-standard">
	
	<div id="sampleModalUpdateNew" class="modal fade" role="dialog">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"> Update Engagement</h4>
			</div>
			<div class="modal-body" style="padding: 20px 30px;">
				<div class="row mt-10">
			      	<div class="col-lg-6">
						<input type="hidden" class="form-control" name="id" id="id">
						<input type="hidden" class="form-control" name="subdomain" id="subdomain">
						<div class="form-group row">
							<label class="control-label col-sm-4" for="client">Client:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="client" id="client" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="engagement">Engagement Name:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="engagement" id="engagement" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="scope">Scope of Work:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="scope" id="scope" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="start_date">Start Date:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control datepicker" name="start_date" id="start_date" required>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="end_date">Estimated End:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control datepicker" name="end_date" id="end_date" required>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="status">Engagement Status:</label>
							<div class="col-sm-8">
							    <select class="form-control selectpicker" required name="status" id="status" data-live-search="true">
									<option selected disabled></option>
									<option value="In Process">In Process</option>
									<option value="Finished">Finished</option>
									<option value="Withdrawn">Withdrawn</option>
								</select>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="budget">Overall Budget Hours:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="overall_budget_hours" id="overall_budget_hoursNew" readonly>
							</div>
						</div>
			      	</div>
			      	<div class="col-lg-6">
						<div class="form-group row">
							<label class="control-label col-sm-4" for="referred_by">Referred By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="referred_by" id="referred_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="closed_by">Closed By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="closed_by" id="closed_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="initiated_by">Initiated By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="initiated_by" id="initiated_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="managed_by">Managed By:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="managed_by" id="managed_by" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="type">Type:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="type" id="type" readonly>
							</div>
						</div>
						<div class="form-group row">
							<label class="control-label col-sm-4" for="contract_price">Contract Price:</label>
							<div class="col-sm-8">
							    <input type="text" class="form-control" name="contract_price" id="contract_price" readonly>
							</div>
						</div>
			      	</div>
			      	<div class="col-lg-12">
		      			<label>Budget Per Position:</label>
				      	<div class="table-responsive">
							<table class="table table-striped table-standard" id="budgetPerPositionTableNew">
								<thead>
									<tr class="positionHead">
										
									</tr>
								</thead>
								<tbody>
									<tr class="positionBody">
										
									</tr>
								</tbody>
							</table>
						</div>
			      	</div>
		      	</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn" data-dismiss="modal">Close</button>
				<button type="submit" id="btnSave" class="btn btn-success">Update</button>
			</div>
		</div>

		</div>
	</div>
</form>
<div class="box-standard">
	<div class="row">
		<div class="col-lg-12 col-sm-12">
			<div class="wrap">
				<div class="table-responsive">
					<table class="table table-standard" id="engagement_table">
						<thead>
							<tr>
								<th>Client Name</th>
								<th>Setup No</th>
								<th>Engagement No.</th>
								<th>Engagement Name</th>
								<th>Start Date</th>
								<th>Estimated End</th>
								<th>Overall Budget Hours</th>
								<th>Remaining Budget Hours</th>
								<th>Subdomain</th>
								<th>Engagement Status</th>
								<th>Request Status</th>
								<th>Created By</th>
								<th style="width: 10%"><i class="ti-settings"></i></th>
							</tr>
						</thead>
						<tbody class="engagementData">
						</tbody>
					</table>	
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(function(){
		show();
		$('[data-toggle="popover"]').popover(); 
		$('.sample').click(function(){

			$('#sampleModal').modal({
			  	backdrop: 'static', 
			    keyboard: false,
			    toggle: true
			 });
			getSubdomain();
		})

		$('#engagement_table').on('click', '.updateEngagement', function(){
			// alert();
			var id = $(this).attr('engid');
			var type = $(this).attr('engType');
			showEngagementDetails(id, type);
			showPosition(id, type)
			keyUpPos(type);
		})
		$('#engagement_table').on('click', '.postEngagement', function(){
			// alert();
			var id = $(this).attr('engid');
			saveAlert('You want to post this engagement?',function(){
				$.post(URL+"engagement/postEngagement", {'id':id})
				.done(function(returnData){
					toastr.success('Posted Successfully');
					setTimeout(function(){
						location.reload();
					},2500)
				})
			})
		})
		$('#engagement_table').on('click', '.deleteEngagement', function(){
			// alert();
			var id = $(this).attr('engid');
			saveAlert('You want to delete this engagement?',function(){
				$.post(URL+"engagement/deleteEngagement", {'id':id})
				.done(function(returnData){
					toastr.success('Deleted Successfully');
					setTimeout(function(){
						location.reload();
					},2500)
				})
			})
		})
		$('#formUpdateEngagement, #formUpdateEngagementNew').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to update this engagement?',function(){
				$.post(URL+'engagement/updateEngagement', form)
				.done(function(returnData){
					toastr.success('Updated Successfully');
					setTimeout(function(){
						location.reload();
					},2500)
				})
			});
			return false;
		})
		$('#formGenerateMapEngagement').submit(function(){
			var form = $(this).serialize();
			showFilter(form)
			$('#sampleModal').modal('hide');
			return false;
		})
	})
	function show(){
		tableLoader('#engagement_table');
		$.post(URL+'engagement/getEngagementList')
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data, function(key,a){
				var buttons = '';
				if(a.eng_status!='Posted'){
					buttons = "<a class='postEngagement btn-edit-standard edit-standard-success tooltip-standard-left' engId='"+a.eng_id+"' title-standard='Post Engagement'><i class='fa fa-check-square-o'></i></a>"+
					"<a class='deleteEngagement btn-edit-standard edit-standard-danger tooltip-standard-left' engId='"+a.eng_id+"' title-standard='Cancel Engagement'><i class='fa fa-ban'></i></a>";
				}
				append += "<tr>"+
							"<td>"+a.client+"</td>"+
							"<td>"+a.setup_no+"</td>"+
							"<td>"+a.engagement_no+"</td>"+
							"<td>"+a.engagement+"</td>"+
							"<td>"+a.date_start+"</td>"+
							"<td>"+a.date_end+"</td>"+
							"<td>"+a.overall_budget_hours+"</td>"+
							"<td>"+parseFloat(a.remaining_budget).toFixed(2)+"</td>"+
							"<td>"+a.subdomain+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+a.eng_status+"</td>"+
							"<td>"+a.username+"</td>"+
							"<td>"+
								"<a class='updateEngagement btn-edit-standard tooltip-standard-left' engType='"+a.setup_no+"' engId='"+a.eng_id+"' title-standard='Edit Engagement'><i class='fa fa-pencil-square-o'></i></a>"
								+buttons+
							"</td>"+
						"</tr>";
			
			})
			$('#engagement_table tbody').html(append);
			var table = $('#engagement_table').removeAttr('width').DataTable( {
					scrollY:        "400px",
					scrollX:        true,
					scrollCollapse: true,
					ordering: false,
					columnDefs: [
						{ "width": "70px", "targets": 0 },
						{ "width": "100px", "targets": 1 },
						{ "width": "50px", "targets": 2 },
						{ "width": "50px", "targets": 3 },
					],
					fixedColumns:   {
						leftColumns: 4
					}
			} );
		})
	}
	function showFilter(form){
		$('#engagement_table').DataTable().destroy();
		tableLoader('#engagement_table');
		$.post(URL+'engagement/getEngagementListFiltered', form)
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data, function(key,a){
				var buttons = '';
				if(a.eng_status!='Posted'){
					buttons = "<a class='postEngagement btn-edit-standard edit-standard-success tooltip-standard-left' engId='"+a.eng_id+"' title-standard='Post Engagement'><i class='fa fa-check-square-o'></i></a>"+
					"<a class='deleteEngagement btn-edit-standard edit-standard-danger tooltip-standard-left' engId='"+a.eng_id+"' title-standard='Cancel Engagement'><i class='fa fa-ban'></i></a>";
				}
				append += "<tr>"+
							"<td>"+a.client+"</td>"+
							"<td>"+a.setup_no+"</td>"+
							"<td>"+a.engagement_no+"</td>"+
							"<td>"+a.engagement+"</td>"+
							"<td>"+a.date_start+"</td>"+
							"<td>"+a.date_end+"</td>"+
							"<td>"+a.overall_budget_hours+"</td>"+
							"<td>"+parseFloat(a.remaining_budget).toFixed(2)+"</td>"+
							"<td>"+a.subdomain+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+a.eng_status+"</td>"+
							"<td>"+a.username+"</td>"+
							"<td>"+
								"<a class='updateEngagement btn-edit-standard tooltip-standard-left' engType='"+a.setup_no+"' engId='"+a.eng_id+"' title-standard='Edit Engagement'><i class='fa fa-pencil-square-o'></i></a>"
								+buttons+
							"</td>"+
						"</tr>";
			
			})
			$('#engagement_table tbody').html(append);
			var table = $('#engagement_table').removeAttr('width').DataTable( {
					scrollY:        "400px",
					scrollX:        true,
					scrollCollapse: true,
					ordering: false,
					columnDefs: [
						{ "width": "50px", "targets": 0 },
						{ "width": "200px", "targets": 1 },
						{ "width": "40px", "targets": 2 },
						{ "width": "40px", "targets": 3 },
					],
					fixedColumns:   {
						leftColumns: 4
					}
			} );
		})
	}
	function showPosition(id, type){
		if(type == 'null' || type == ''){
			tableSample = '#budgetPerPositionTable';
		} else {
			tableSample = '#budgetPerPositionTableNew';
		}
		$.post(URL +'engagement/getEngagementBudget', {'id':id})
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append ='';
			var append1 ='';
			$.each(data, function(key,a){
				append += '<th>'+a.position+'</th>';
				append1 += '<td><input type="text" name="budget[]" class="form-control budget" value ='+a.budget_hours+'><input type="text" hidden name="positionId[]" value ='+a.id+'></td>';
			});
			$(tableSample).find('thead tr.positionHead').html(append);
			$(tableSample).find('tbody tr.positionBody').html(append1);
			
		});
	}
	function showEngagementDetails(id, type){
		if(type == 'null' || type == ''){
			detailUrl = 'engagement/showEngagementDetails';
			modalSample = '#sampleModalUpdate';
		} else {
			detailUrl = 'engagement/showEngagementDetailsNew';
			modalSample = '#sampleModalUpdateNew';
		}
		$.post(URL + detailUrl,{'id':id})
		.done(function(returnData){
		    console.log(returnData)
			var data = $.parseJSON(returnData);
			var a = data[0];
			$(modalSample).find('input[name="id"]').val(id);
			$(modalSample).find('input[name="client"]').val(a.client);
			$(modalSample).find('input[name="scope"]').val(a.scope);
			$(modalSample).find('input[name="engagement"]').val(a.engagement);
			$(modalSample).find('input[name="start_date"]').val(a.date_start);
			$(modalSample).find('input[name="end_date"]').val(a.date_end);
			$(modalSample).find('input[name="overall_budget_hours"]').val(a.overall_budget_hours);
			$(modalSample).find('select[name="status"]').val(a.status).change();
			$(modalSample).find('input[name="referred_by"]').val(a.referred_by);
			$(modalSample).find('input[name="initiated_by"]').val(a.initiated_by);
			$(modalSample).find('input[name="closed_by"]').val(a.closed_by);
			$(modalSample).find('input[name="managed_by"]').val(a.managed_by);
			$(modalSample).find('input[name="managed_by"]').val(a.managed_by);
			$(modalSample).find('input[name="type"]').val(a.client_type);
			$(modalSample).find('input[name="contract_price"]').val(addCommas(a.contract_price));
			$(modalSample).find('input[name="subdomain"]').val(a.subdomain);
			$(modalSample).modal({
				backdrop: 'static', 
				keyboard: false,
				toggle: true
			});
		});
	}

	function keyUpPos(type){
		if(type == 'null' || type == ''){
			budget_hours = '#overall_budget_hours';
		} else {
			budget_hours = '#overall_budget_hoursNew';
		}
		$(document).on('keyup', '.budget', function(){
			var x = 0;
			$('.budget').each(function(){
				x += $(this).val() != '' ? parseInt($(this).val()) : 0;
			});
			$(budget_hours).val(parseInt(x));
		});
	}
	function getSubdomain(){
		$.post(URL + 'employee/showSubdomains')
		.done(function(returnData){
			var data = $.parseJSON(returnData);

			var append = '<option value="%%">All</option>';
			$.each(data,function(key,a){
				append +=  '<option value="'+a.username+'">'+a.subdomain+'</option>';
			})
			$('#formGenerateMapEngagement').find('select[name=subdomain]').html(append);
			$('#formGenerateMapEngagement').find('select[name=subdomain]').selectpicker('refresh');
		})
	}
</script>