$(function(){
		getSubdomain();

		$('#table_manPowerReport').on('click','.subview',function(){
			$('#reportModal').modal({
				backdrop: 'static',
				keyboard: false,
				toggle: true
			});
			var uid = $(this).attr('uid');
			var sub = $('select[name="subdomain"]').val();
			var from = $('input[name="from"]').val();
			var to = $('input[name="to"]').val();

			generateMpSummary(uid,from,to);
		});

		$('#generateManPowerReport').submit(function(){
			$('#table_manPowerReport').DataTable().destroy();
			tableLoader('#table_manPowerReport');
			form = $(this).serialize();

			$.post(URL + 'reports/generateManPowerReport',form)
			.done(function(returnData){

				data = $.parseJSON(returnData);
				append ='';

				$.each(data, function(key,a){

					if(a.forecast_status !== null || a.forecast_status =='pending'){

						status = "<button type='button' class='btn btn-block alert-button-success subview' uid="+a.user_id+">View</button>";
					}
					else{

						status = "<button type='button' class='btn btn-block alert-button-danger'>No Forecast</button>";
					}
					append +=
								"<tr>"+
								"<td>"+a.company_identification+"</td>"+
								"<td>"+a.name+"</td>"+
								"<td>"+a.position+"</td>"+
								"<td>"+status+"</td>"+
								"</tr>";
				});

				$('#table_manPowerReport').find('.data_man_power').html(append);
				$('#table_manPowerReport').DataTable();

			});

			return false;

		});


	});

function getSubdomain(){
			
	$.post(URL + 'employee/showSubdomains')
	.done(function(returnData){


		var data = $.parseJSON(returnData);

		var append = '';
		$.each(data,function(key,a){
			append +=  '<option value="'+a.id+'">'+a.subdomain+'</option>';
		})
		$('#generateManPowerReport').find('select[name=subdomain]').html(append);
		$('#generateManPowerReport').find('select[name=subdomain]').selectpicker('refresh');
	})
}

function generateMpSummary(uid,from,to){
	$('#mp_table').DataTable().destroy();
	tableLoader('#mp_table');
	$.post(URL + 'reports/generateMpSummary',{'uid':uid,'from':from,'to':to})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';

		$.each(data,function(key,a){
			append+=
				"<tr>"+
					"<td>"+a.rank+"</td>"+
					"<td>"+a.client+"</td>"+
					"<td>"+a.engagement+"</td>"+
					"<td>"+a.tba+"</td>"+
					"<td>"+a.nbt+"</td>"+
					"<td>"+a.target+"</td>"+
					"<td>"+a.budget_hrs+"</td>"+
					"<td>"+a.to_do_date+"</td>"+
				"</tr>";
		})
		$('#mp_table').find('#mp_data').html(append);
		$('#mp_table').DataTable();
	})
}