<?php
require('fpdf181/fpdf.php');
class PDF extends FPDF
{
	public function Circle($x, $y, $r, $style='D')
	{
	    $this->Ellipse($x,$y,$r,$r,$style);
	}
	function Ellipse($x, $y, $rx, $ry, $style='D')
	{
	    if($style=='F')
	        $op='f';
	    elseif($style=='FD' || $style=='DF')
	        $op='B';
	    else
	        $op='S';
	    $lx=4/3*(M_SQRT2-1)*$rx;
	    $ly=4/3*(M_SQRT2-1)*$ry;
	    $k=$this->k;
	    $h=$this->h;
	    $this->_out(sprintf('%.2F %.2F m %.2F %.2F %.2F %.2F %.2F %.2F c',
	        ($x+$rx)*$k,($h-$y)*$k,
	        ($x+$rx)*$k,($h-($y-$ly))*$k,
	        ($x+$lx)*$k,($h-($y-$ry))*$k,
	        $x*$k,($h-($y-$ry))*$k));
	    $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c',
	        ($x-$lx)*$k,($h-($y-$ry))*$k,
	        ($x-$rx)*$k,($h-($y-$ly))*$k,
	        ($x-$rx)*$k,($h-$y)*$k));
	    $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c',
	        ($x-$rx)*$k,($h-($y+$ly))*$k,
	        ($x-$lx)*$k,($h-($y+$ry))*$k,
	        $x*$k,($h-($y+$ry))*$k));
	    $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c %s',
	        ($x+$lx)*$k,($h-($y+$ry))*$k,
	        ($x+$rx)*$k,($h-($y+$ly))*$k,
	        ($x+$rx)*$k,($h-$y)*$k,
	        $op));
	}
	function AddFonts(){
		$this->AddFont('HelveticaNeueThin','','HelveticaNeueThin.php');
		$this->AddFont('HelveticaNeueLTPro65Md','','HelveticaNeueLTPro65Md.php');
		$this->AddFont('HelveticaNeueLTPro-Bd','','HelveticaNeueLTPro-Bd.php');
	}
	function CompanyLogo($c){
		if($c == 'agm'){
			$this->Image('id_gen/agm.png', 29, 4, 21, 0,'PNG');
		} else if ($c == 'scp'){
			$this->Image('id_gen/scp.png', 29, 4, 21, 0,'PNG');
		} else if ($c == 'i4one'){
			$this->Image('id_gen/bgi4one.png', -2, 0, 32, 0,'PNG');
			$this->Image('id_gen/i4one.png', 28, 4, 23, 0,'PNG');
		}
	}
	function IdName($c,$nname,$name,$signature){
		if($c == 'agm'){
			$this->SetTextColor(0,0,0);
		} else if ($c == 'scp'){
			$this->SetTextColor(23,165,74);
		} else if ($c == 'i4one'){
			$this->SetTextColor(0,101,166);
		}
		$this->SetXY(27,23);
		$this->SetFont('helvetica','B',10.5);
		$this->MultiCell(27, 2.5,strtoupper($nname),0,'C');
		$this->SetXY(27,26.5);
		$this->SetFont('HelveticaNeueLTPro-Bd','',5);
		$this->MultiCell(27, 2.5,$name, 0,'C');
		$this->Image($signature, (10.5-(14/2))+30, 30, 14, 0,'PNG');
		$this->SetFillColor(0,0,0);
		$this->Rect(30.5, 35.5, 21, .13, 'F');
		$this->SetXY(27,35.5);
		$this->SetFont('helvetica','',4);
		$this->MultiCell(27, 2.5,'Signature',0,'C');
	}
	function IdFooter($c,$p,$idno){

		if($c == 'agm'){
			$this->SetFillColor(54,190,186);
		} else if ($c == 'scp'){
			$this->SetFillColor(23,165,74);
		} else if ($c == 'i4one'){
			$this->SetFillColor(23,165,74);
		}
		$this->Rect(0, 73, 200, 50, 'F');

		$this->SetTextColor(255, 255, 255);
		$this->SetFont('HelveticaNeueLTPro-Bd','',9);
		$this->Text(27-($this->GetStringWidth($p)/2), 76.7,$p);

		if($c == 'agm'){
			$this->SetFillColor(0,0,0);
		} else if ($c == 'scp'){
			$this->SetFillColor(32,57,110);
		} else if ($c == 'i4one'){
			$this->SetFillColor(0,101,166);
		}
		$this->Rect(0, 78, 200, 10, 'F');
		$this->SetFont('helvetica','B',6.5);
		$this->Text(27-($this->GetStringWidth('ID NUMBER: '.$idno)/2), 82.5,'ID NUMBER: '.$idno);
		$this->Image('id_gen/violator.png',42.9, 80.5, 11, 0,'PNG');
	}
	function BackPage_header($color,$c){
		$this->SetFillColor($color['r'],$color['g'],$color['b']); // company color
		$this->Rect(0, 0, 200, 20, 'F');
		$this->SetFont('HelveticaNeueLTPro65Md','',6);
		$this->SetTextColor(255, 255, 255);
		$this->Text(13, 4, '2003A 20th  Floor West Tower');
		$this->Text(7.5, 6.5, 'PSE Exchange Ortigas Center, Pasig City');
		$this->SetFillColor(255,255,255);
		$this->Rect(0, 9, 200, 72, 'F');
		$this->SetFont('HelveticaNeueLTPro65Md','',5.6);
		$this->SetTextColor(0, 0, 0);
		$this->Text(6, 13, 'This is to certify that the person whose picture');
		$this->Text(7.5, 15.3, 'signature appear hereon is an employee of');
		$this->SetFont('HelveticaNeueLTPro-Bd','',5.6);
		if($c == 'agm'){
			$this->Text(13, 17.8, 'Aktus Global Management Inc.');
		} else if($c == 'scp'){
			$this->Text(22, 17.8, 'SCP & Co.');
		} else if($c == 'i4one'){
			$this->Text(23, 17.8, 'i4one Inc.');
		}
		$this->SetFont('HelveticaNeueLTPro-Bd','',6);
		$this->SetTextColor($color['r'],$color['g'],$color['b']); // company color
		$this->Text(3.5, 23, 'IN CASE OF EMERGENCY, PLEASE CONTACT:');
		$this->SetFillColor($color['r'],$color['g'],$color['b']);  
	}
	function BackPage($c,$contact_name,$contact_address, $contact_number, $sss,$tin,$phil,$hdmf){

		if($c == 'agm'){
			$color['r'] = 54;
			$color['g'] = 190;
			$color['b'] = 186;
		} else if($c == 'scp'){
			$color['r'] = 23;
			$color['g'] = 165;
			$color['b'] = 74;
		} else if($c == 'i4one'){
			$color['r'] = 0;
			$color['g'] = 101;
			$color['b'] = 166;
		}

		$this->BackPage_header($color,$c);

		$this->SetFont('helvetica','B',6);
		$this->SetTextColor(0,0,0); // company color
		$this->Circle(8,30,1.5,'F');
		$this->Text(12, 30.6, $contact_name);
		$this->Circle(8,34,1.5,'F');
		$this->SetY(32.5);
		$this->SetX(11);
		$this->MultiCell(40, 2.5,$contact_address,0,'L');
		$this->Circle(8,43,1.5,'F');
		$this->Text(12, 43.6, $contact_number);

		$this->Image('id_gen/user.png', 7.26, 29.2, 1.5,0,'PNG');
		$this->Image('id_gen/home.png', 7.26, 33.2, 1.5,0,'PNG');
		$this->Image('id_gen/phone.png', 7.26, 42.2, 1.5,0,'PNG');


		$this->SetTextColor(0, 0, 0);
		$this->SetFont('helvetica','B',6);
		!empty($sss) ? $this->Text(8.5, 50, 'SSS NO.: '.$sss) : '';
		!empty($tin) ? $this->Text(8.5, 52.7, 'TIN: '.$tin) : '';
		!empty($phil) ? $this->Text(8.5, 55.5, 'PHILHEALTH NO.: '.$phil) : '';
		!empty($hdmf) ? $this->Text(8.5, 58.3, 'HDMF NO.: '.$hdmf) : '';
		
		$this->BackPage_footer($color);
	}
	function BackPage_footer($color){
		$this->SetFont('helvetica','B',8);
		$this->Text(18, 71, 'Neil U. Sison');
		$this->SetFont('helvetica','',5);
		$this->Text(17.5, 73, 'MANAGING PARTNER');
		$this->Image('id_gen/nus.png',20, 62.5, 14,0,'PNG');
		$this->SetFillColor($color['r'],$color['g'],$color['b']);  
		$this->Rect(0, 78, 200, 10, 'F');
		$this->SetFont('HelveticaNeueLTPro65Md','',5.5);
		$this->SetTextColor(255, 255, 255);
		$this->Text(2.5, 81.5, 'This is a company property and should be surrendered');
		$this->Text(3, 83.5, 'upon resignation and/or separation from employment.');
	}
}


?>