<?php
/**
 * Class that operate on table 'tbl_client'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-03-27 03:27
 */
class TblClientMySqlDAO implements TblClientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblClientMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_client WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_client';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_client ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblClient primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_client WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientMySql tblClient
 	 */
	public function insert($tblClient){
		$sql = 'INSERT INTO tbl_client (subdomain, client_no, client, key_accounts_id, contract_price, type, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblClient->subdomain);
		$sqlQuery->set($tblClient->clientNo);
		$sqlQuery->set($tblClient->client);
		$sqlQuery->setNumber($tblClient->keyAccountsId);
		$sqlQuery->set($tblClient->contractPrice);
		$sqlQuery->set($tblClient->type);
		$sqlQuery->set($tblClient->dateCreated);
		$sqlQuery->set($tblClient->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblClient->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientMySql tblClient
 	 */
	public function update($tblClient){
		$sql = 'UPDATE tbl_client SET subdomain = ?, client_no = ?, client = ?, key_accounts_id = ?, contract_price = ?, type = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblClient->subdomain);
		$sqlQuery->set($tblClient->clientNo);
		$sqlQuery->set($tblClient->client);
		$sqlQuery->setNumber($tblClient->keyAccountsId);
		$sqlQuery->set($tblClient->contractPrice);
		$sqlQuery->set($tblClient->type);
		$sqlQuery->set($tblClient->dateCreated);
		$sqlQuery->set($tblClient->dateModified);

		$sqlQuery->setNumber($tblClient->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_client';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_client WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientNo($value){
		$sql = 'SELECT * FROM tbl_client WHERE client_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM tbl_client WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByKeyAccountsId($value){
		$sql = 'SELECT * FROM tbl_client WHERE key_accounts_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContractPrice($value){
		$sql = 'SELECT * FROM tbl_client WHERE contract_price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByType($value){
		$sql = 'SELECT * FROM tbl_client WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_client WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_client WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_client WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientNo($value){
		$sql = 'DELETE FROM tbl_client WHERE client_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM tbl_client WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByKeyAccountsId($value){
		$sql = 'DELETE FROM tbl_client WHERE key_accounts_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContractPrice($value){
		$sql = 'DELETE FROM tbl_client WHERE contract_price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByType($value){
		$sql = 'DELETE FROM tbl_client WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_client WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_client WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblClientMySql 
	 */
	protected function readRow($row){
		$tblClient = new TblClient();
		
		$tblClient->id = $row['id'];
		$tblClient->subdomain = $row['subdomain'];
		$tblClient->clientNo = $row['client_no'];
		$tblClient->client = $row['client'];
		$tblClient->keyAccountsId = $row['key_accounts_id'];
		$tblClient->contractPrice = $row['contract_price'];
		$tblClient->type = $row['type'];
		$tblClient->dateCreated = $row['date_created'];
		$tblClient->dateModified = $row['date_modified'];

		return $tblClient;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblClientMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>