<?php
/**
 * Class that operate on table 'tbl_employee_setup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblEmployeeSetupMySqlDAO implements TblEmployeeSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblEmployeeSetupMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_employee_setup';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_employee_setup ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblEmployeeSetup primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_employee_setup WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEmployeeSetupMySql tblEmployeeSetup
 	 */
	public function insert($tblEmployeeSetup){
		$sql = 'INSERT INTO tbl_employee_setup (employee, shift, time_in, time_out, nholiday, r_mon, r_tue, r_wed, r_thu, r_fri, r_sat, r_sun, alternate, client, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEmployeeSetup->employee);
		$sqlQuery->set($tblEmployeeSetup->shift);
		$sqlQuery->set($tblEmployeeSetup->timeIn);
		$sqlQuery->set($tblEmployeeSetup->timeOut);
		$sqlQuery->set($tblEmployeeSetup->nholiday);
		$sqlQuery->set($tblEmployeeSetup->rMon);
		$sqlQuery->set($tblEmployeeSetup->rTue);
		$sqlQuery->set($tblEmployeeSetup->rWed);
		$sqlQuery->set($tblEmployeeSetup->rThu);
		$sqlQuery->set($tblEmployeeSetup->rFri);
		$sqlQuery->set($tblEmployeeSetup->rSat);
		$sqlQuery->set($tblEmployeeSetup->rSun);
		$sqlQuery->set($tblEmployeeSetup->alternate);
		$sqlQuery->set($tblEmployeeSetup->client);
		$sqlQuery->set($tblEmployeeSetup->date);

		$id = $this->executeInsert($sqlQuery);	
		$tblEmployeeSetup->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEmployeeSetupMySql tblEmployeeSetup
 	 */
	public function update($tblEmployeeSetup){
		$sql = 'UPDATE tbl_employee_setup SET employee = ?, shift = ?, time_in = ?, time_out = ?, nholiday = ?, r_mon = ?, r_tue = ?, r_wed = ?, r_thu = ?, r_fri = ?, r_sat = ?, r_sun = ?, alternate = ?, client = ?, date = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEmployeeSetup->employee);
		$sqlQuery->set($tblEmployeeSetup->shift);
		$sqlQuery->set($tblEmployeeSetup->timeIn);
		$sqlQuery->set($tblEmployeeSetup->timeOut);
		$sqlQuery->set($tblEmployeeSetup->nholiday);
		$sqlQuery->set($tblEmployeeSetup->rMon);
		$sqlQuery->set($tblEmployeeSetup->rTue);
		$sqlQuery->set($tblEmployeeSetup->rWed);
		$sqlQuery->set($tblEmployeeSetup->rThu);
		$sqlQuery->set($tblEmployeeSetup->rFri);
		$sqlQuery->set($tblEmployeeSetup->rSat);
		$sqlQuery->set($tblEmployeeSetup->rSun);
		$sqlQuery->set($tblEmployeeSetup->alternate);
		$sqlQuery->set($tblEmployeeSetup->client);
		$sqlQuery->set($tblEmployeeSetup->date);

		$sqlQuery->setNumber($tblEmployeeSetup->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_employee_setup';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEmployee($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE employee = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByShift($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE shift = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeIn($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE time_in = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeOut($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNholiday($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE nholiday = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRMon($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_mon = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRTue($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_tue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRWed($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_wed = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRThu($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_thu = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRFri($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_fri = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRSat($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_sat = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRSun($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE r_sun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAlternate($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE alternate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM tbl_employee_setup WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEmployee($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE employee = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByShift($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE shift = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeIn($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE time_in = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeOut($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNholiday($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE nholiday = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRMon($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_mon = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRTue($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_tue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRWed($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_wed = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRThu($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_thu = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRFri($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_fri = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRSat($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_sat = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRSun($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE r_sun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAlternate($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE alternate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM tbl_employee_setup WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblEmployeeSetupMySql 
	 */
	protected function readRow($row){
		$tblEmployeeSetup = new TblEmployeeSetup();
		
		$tblEmployeeSetup->id = $row['id'];
		$tblEmployeeSetup->employee = $row['employee'];
		$tblEmployeeSetup->shift = $row['shift'];
		$tblEmployeeSetup->timeIn = $row['time_in'];
		$tblEmployeeSetup->timeOut = $row['time_out'];
		$tblEmployeeSetup->nholiday = $row['nholiday'];
		$tblEmployeeSetup->rMon = $row['r_mon'];
		$tblEmployeeSetup->rTue = $row['r_tue'];
		$tblEmployeeSetup->rWed = $row['r_wed'];
		$tblEmployeeSetup->rThu = $row['r_thu'];
		$tblEmployeeSetup->rFri = $row['r_fri'];
		$tblEmployeeSetup->rSat = $row['r_sat'];
		$tblEmployeeSetup->rSun = $row['r_sun'];
		$tblEmployeeSetup->alternate = $row['alternate'];
		$tblEmployeeSetup->client = $row['client'];
		$tblEmployeeSetup->date = $row['date'];

		return $tblEmployeeSetup;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblEmployeeSetupMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>