<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblUserRateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserRate 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserRate primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserRate tblUserRate
 	 */
	public function insert($tblUserRate);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserRate tblUserRate
 	 */
	public function update($tblUserRate);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByRate($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByUserId($value);

	public function deleteByRate($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>