<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblProjectBudgetDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblProjectBudget 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblProjectBudget primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblProjectBudget tblProjectBudget
 	 */
	public function insert($tblProjectBudget);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblProjectBudget tblProjectBudget
 	 */
	public function update($tblProjectBudget);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProjectId($value);

	public function queryByActId($value);

	public function queryByPosition($value);

	public function queryByBudgetHours($value);

	public function queryByAdditionalBudget($value);


	public function deleteByProjectId($value);

	public function deleteByActId($value);

	public function deleteByPosition($value);

	public function deleteByBudgetHours($value);

	public function deleteByAdditionalBudget($value);


}
?>