$(function(){
	$('#table_db').on('click', '.subview', function(){
		$('#reportModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var subdomain = $(this).attr('subid');
		var date = $('input[name="date"]').val();
		dbReportSummary(date,subdomain);
	});

	$('#generateDb').submit(function(){
		$('#table_db').DataTable().destroy();
		tableLoader('#table_db');
		var form = $(this).serialize();
		$.post(URL + 'reports/generateDashboard', form)
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			var appendTotal = '';
			var tot_target = 0;
			var tot_actual = 0;
			var tot_var = 0; 
			$.each(data,function(key,a){
				tot_target += parseInt(a.target);
				tot_actual += parseInt(a.actual);
				tot_var += parseInt(a.variance);

				append += "<tr>"+
								"<td><a class='subview' subid='"+a.sub_id+"'>"+a.sub_username+"</a></td>"+
								"<td>"+a.target+"</td>"+
								"<td>"+a.actual+"</td>"+
								"<td>"+a.variance+"</td>"+
						"</tr>";
			})

			appendTotal = "<tr>"+
							"<th>Over All Total</th>"+
							"<th>"+tot_target+"</th>"+
							"<th>"+tot_actual+"</th>"+
							"<th>"+tot_var+"</th>"+
						"</tr>";

			$('#table_db').find(".data_db").html(append);
			$('#table_db').find(".data_db").append(appendTotal);
			
			$('#table_db').DataTable({
			    "ordering": false  
			});
		})
		return false;
	})

	$('.btnExport').click(function(){
		date = $('input[name="date"]').val();

		window.location = URL +"export/dashboard?date="+date;
	})
	$('.btnExport2').click(function(){
		date = $('input[name="date"]').val();
		subdomain = $('.subview').attr('subid');

		window.location = URL +"export/dashboard2?date="+date+"&subdomain="+subdomain;
	})

})

function dbReportSummary(date,subdomain){
	$('#db_summary_table').DataTable().destroy();	
	tableLoader('#db_summary_table');
	$.post(URL + 'reports/generateDpr2', {'date':date,'subdomain': subdomain})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		var appendTot = '';
		var submitted = 0;
		var notsubmitted = 0;
		var target = 0;
		var tottarget = 0;
		$.each(data,function(key,a){
			status1 = parseInt(a.nbt == 'done' ? 1: 0);
			status2 = parseInt(a.nbt == 'no report' ? 1: 0);
			submitted += parseInt(status1); 
			notsubmitted += parseInt(status2);
			target = parseInt(a.nbt == 'done' ? 1: 1);
			tottarget += parseInt(target);
			append += "<tr>"+
								"<td>"+a.name+"</td>"+
								"<td>"+a.position+"</td>"+
								"<td class='text-right'>"+target+"</td>"+
								"<td>"+status1+"</td>"+
								"<td>"+status2+"</td>"+
						"</tr>";
		});
		appendTot = "<tr>"+
						"<th>Total</th>"+
						"<th></th>"+
						"<th class='text-right'>"+tottarget+"</th>"+
						"<th>"+submitted+"</th>"+
						"<th>"+notsubmitted+"</th>"+
					"</tr>";
		$('#db_summary_table').find(".dbSummaryData").html(append);	
		$('#db_summary_table').find(".dbSummaryData").append(appendTot);
		$('#db_summary_table').DataTable({
			"ordering": false
		});	
	})
	return false;
}