<?php
/**
 * Class that operate on table 'tbl_engagement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblEngagementMySqlExtDAO extends TblEngagementMySqlDAO{
	function getEngagementList(){
		$sql = "
				SELECT 
					tes.id eng_id,
					tc.id client_id,
					tc.client,
					te.engagement_no engagement_no,
					te.engagement,
					tes.date_start,
					tes.date_end,
					tes.overall_budget_hours,
					tes.eng_status,
					tes.status,
					tes.subdomain
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_client tc
				ON
					tc.id = tes.client_id
				INNER JOIN
					tbl_engagement te
				ON
					te.id = tes.engagement_id
				WHERE 
					tes.eng_status = 'Saved'
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementListFiltered($status,$subdomain){
		$sql = "
				SELECT 
					tes.id eng_id,
					tc.id client_id,
					tc.client,
					te.engagement_no engagement_no,
					te.engagement,
					tes.date_start,
					tes.date_end,
					tes.overall_budget_hours,
					tes.eng_status,
					tes.status,
					tes.subdomain
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_client tc
				ON
					tc.id = tes.client_id
				INNER JOIN
					tbl_engagement te
				ON
					te.id = tes.engagement_id

				WHERE 
					tes.eng_status LIKE '$status'
				AND
					tes.subdomain LIKE '$subdomain'
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementDetails($eng){
		$sql = "
				SELECT 
					tc.client_no,
					tc.`client`,
					tc.contract_price,
					tc.`type` client_type,
					te.engagement_no,
					te.engagement,
					tes.date_start,
					tes.date_end,
					tes.overall_budget_hours,
					tes.status,
					tes.subdomain,
					CONCAT(tn_referred_by.fname,' ',tn_referred_by.mname,' ',tn_referred_by.lname) referred_by,
					CONCAT(tn_initiated_by.fname,' ',tn_initiated_by.mname,' ',tn_initiated_by.lname) initiated_by,
					CONCAT(tn_closed_by.fname,' ',tn_closed_by.mname,' ',tn_closed_by.lname) closed_by,
					CONCAT(tn_managed_by.fname,' ',tn_managed_by.mname,' ',tn_managed_by.lname) managed_by
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_client tc
				ON
					tc.id = tes.client_id
				INNER JOIN
					tbl_engagement te
				ON	
					te.id = tes.engagement_id
				INNER JOIN
					tbl_key_accounts tka
				ON 	
					tka.id = tc.key_accounts_id
				INNER JOIN
					tbl_names tn_referred_by
				ON
					tn_referred_by.id = tka.referred_by
				INNER JOIN
					tbl_names tn_initiated_by
				ON
					tn_initiated_by.id = tka.initiated_by
				INNER JOIN
					tbl_names tn_closed_by
				ON
					tn_closed_by.id = tka.closed_by
				INNER JOIN
					tbl_names tn_managed_by
				ON
					tn_managed_by.id = tka.managed_by
					
				WHERE tes.id = $eng
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementBudget($eng){
		$sql = "
				SELECT 
					tp.id,
					tp.position_no,
					tp.position,
					tbhpp.budget_hours
									
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_budget_hours_per_position tbhpp
				ON
					tbhpp.engagement_setup_id = tes.id
				INNER JOIN
					tbl_position tp
				ON	
					tp.id = tbhpp.position_id

				WHERE tes.id = $eng
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function showEngagement(){
		$sql = "
				SELECT 
					te.*,
					IF(ttpe.id IS NULL, 'no' , 'yes') `check_tba`,
					IF(tepd.id IS NULL, 'no' , 'yes') `check_dept`
				FROM 
					tbl_engagement te
				LEFT JOIN
					tbl_engagement_per_dept tepd
				ON
					tepd.engagement_id = te.id
				LEFT JOIN
					tbl_tba_per_eng ttpe
				ON
					ttpe.eng_per_dept_id = tepd.id

				GROUP BY te.id
				ORDER BY te.id DESC
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function showEngHasAct(){
		$sql = "
				SELECT 
					te.*
				FROM 
					tbl_engagement te
				LEFT JOIN
					tbl_engagement_per_dept tepd
				ON
					tepd.engagement_id = te.id
				LEFT JOIN
					tbl_tba_per_eng ttpe
				ON
					ttpe.eng_per_dept_id = tepd.id
				WHERE ttpe.id IS NOT NULL AND tepd.id IS NOT NULL AND te.status = 'enabled'
				GROUP BY te.id
				ORDER BY te.id DESC
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function showDepartmentPerEng($engid){
		$sql = "
				SELECT 
					td.*
				FROM 
					tbl_department td
				LEFT JOIN
					tbl_engagement_per_dept tepd
				ON
					tepd.dept_id = td.id
				WHERE
					tepd.engagement_id = $engid
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function showEngPerDept($engid,$deptid){
		$sql = "
				SELECT 
					tepd.*
				FROM
					tbl_engagement_per_dept tepd
				WHERE
					tepd.engagement_id = $engid
				AND 
					tepd.dept_id = $deptid
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>