<?php
/**
 * Class that operate on table 'tbl_leave_per_type'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblLeavePerTypeMySqlDAO implements TblLeavePerTypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeavePerTypeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_per_type';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_per_type ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeavePerType primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeavePerTypeMySql tblLeavePerType
 	 */
	public function insert($tblLeavePerType){
		$sql = 'INSERT INTO tbl_leave_per_type (leave_type_id, leave_id, default_credits, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeavePerType->leaveTypeId);
		$sqlQuery->setNumber($tblLeavePerType->leaveId);
		$sqlQuery->set($tblLeavePerType->defaultCredits);
		$sqlQuery->setNumber($tblLeavePerType->createdBy);
		$sqlQuery->setNumber($tblLeavePerType->modifiedBy);
		$sqlQuery->set($tblLeavePerType->dateCreated);
		$sqlQuery->set($tblLeavePerType->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeavePerType->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeavePerTypeMySql tblLeavePerType
 	 */
	public function update($tblLeavePerType){
		$sql = 'UPDATE tbl_leave_per_type SET leave_type_id = ?, leave_id = ?, default_credits = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeavePerType->leaveTypeId);
		$sqlQuery->setNumber($tblLeavePerType->leaveId);
		$sqlQuery->set($tblLeavePerType->defaultCredits);
		$sqlQuery->setNumber($tblLeavePerType->createdBy);
		$sqlQuery->setNumber($tblLeavePerType->modifiedBy);
		$sqlQuery->set($tblLeavePerType->dateCreated);
		$sqlQuery->set($tblLeavePerType->dateModified);

		$sqlQuery->setNumber($tblLeavePerType->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_per_type';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByLeaveTypeId($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE leave_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLeaveId($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE leave_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDefaultCredits($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE default_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_leave_per_type WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByLeaveTypeId($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE leave_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLeaveId($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE leave_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDefaultCredits($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE default_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_leave_per_type WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeavePerTypeMySql 
	 */
	protected function readRow($row){
		$tblLeavePerType = new TblLeavePerType();
		
		$tblLeavePerType->id = $row['id'];
		$tblLeavePerType->leaveTypeId = $row['leave_type_id'];
		$tblLeavePerType->leaveId = $row['leave_id'];
		$tblLeavePerType->defaultCredits = $row['default_credits'];
		$tblLeavePerType->createdBy = $row['created_by'];
		$tblLeavePerType->modifiedBy = $row['modified_by'];
		$tblLeavePerType->dateCreated = $row['date_created'];
		$tblLeavePerType->dateModified = $row['date_modified'];

		return $tblLeavePerType;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeavePerTypeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>