<?php
/**
 * Class that operate on table 'tbl_leave_credits_per_type_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-04-11 08:51
 */
class TblLeaveCreditsPerTypeTransactionMySqlDAO implements TblLeaveCreditsPerTypeTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveCreditsPerTypeTransactionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCreditsPerTypeTransaction primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCreditsPerTypeTransactionMySql tblLeaveCreditsPerTypeTransaction
 	 */
	public function insert($tblLeaveCreditsPerTypeTransaction){
		$sql = 'INSERT INTO tbl_leave_credits_per_type_transaction (leave_credits_per_type_id, old_credits, new_credits, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->leaveCreditsPerTypeId);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->oldCredits);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->newCredits);
		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->createdBy);
		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->modifiedBy);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->dateCreated);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeaveCreditsPerTypeTransaction->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCreditsPerTypeTransactionMySql tblLeaveCreditsPerTypeTransaction
 	 */
	public function update($tblLeaveCreditsPerTypeTransaction){
		$sql = 'UPDATE tbl_leave_credits_per_type_transaction SET leave_credits_per_type_id = ?, old_credits = ?, new_credits = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->leaveCreditsPerTypeId);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->oldCredits);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->newCredits);
		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->createdBy);
		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->modifiedBy);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->dateCreated);
		$sqlQuery->set($tblLeaveCreditsPerTypeTransaction->dateModified);

		$sqlQuery->setNumber($tblLeaveCreditsPerTypeTransaction->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByLeaveCreditsPerTypeId($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE leave_credits_per_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOldCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE old_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNewCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE new_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type_transaction WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByLeaveCreditsPerTypeId($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE leave_credits_per_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOldCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE old_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNewCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE new_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type_transaction WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveCreditsPerTypeTransactionMySql 
	 */
	protected function readRow($row){
		$tblLeaveCreditsPerTypeTransaction = new TblLeaveCreditsPerTypeTransaction();
		
		$tblLeaveCreditsPerTypeTransaction->id = $row['id'];
		$tblLeaveCreditsPerTypeTransaction->leaveCreditsPerTypeId = $row['leave_credits_per_type_id'];
		$tblLeaveCreditsPerTypeTransaction->oldCredits = $row['old_credits'];
		$tblLeaveCreditsPerTypeTransaction->newCredits = $row['new_credits'];
		$tblLeaveCreditsPerTypeTransaction->createdBy = $row['created_by'];
		$tblLeaveCreditsPerTypeTransaction->modifiedBy = $row['modified_by'];
		$tblLeaveCreditsPerTypeTransaction->dateCreated = $row['date_created'];
		$tblLeaveCreditsPerTypeTransaction->dateModified = $row['date_modified'];

		return $tblLeaveCreditsPerTypeTransaction;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveCreditsPerTypeTransactionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>