<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblNamesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblNames 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblName primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNames tblName
 	 */
	public function insert($tblName);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNames tblName
 	 */
	public function update($tblName);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByFname($value);

	public function queryByMname($value);

	public function queryByLname($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByFname($value);

	public function deleteByMname($value);

	public function deleteByLname($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>