<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblLeaveRequestDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblLeaveRequest 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveRequest primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveRequest tblLeaveRequest
 	 */
	public function insert($tblLeaveRequest);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveRequest tblLeaveRequest
 	 */
	public function update($tblLeaveRequest);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByUserId($value);

	public function queryByApproverId($value);

	public function queryByLeaveId($value);

	public function queryByHoursSpent($value);

	public function queryByReason($value);

	public function queryByDateRequested($value);

	public function queryByApprovedDate($value);

	public function queryByLeaveStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByUserId($value);

	public function deleteByApproverId($value);

	public function deleteByLeaveId($value);

	public function deleteByHoursSpent($value);

	public function deleteByReason($value);

	public function deleteByDateRequested($value);

	public function deleteByApprovedDate($value);

	public function deleteByLeaveStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>