<?php
/**
 * Class that operate on table 'tbl_client_project'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-03-06 02:40
 */
class TblClientProjectMySqlExtDAO extends TblClientProjectMySqlDAO{

	static function searchProject($keyword = '',$client = 0){
		$clients = ($client == 0) ? '' : " AND client_id = ".$client ;
		$txt = "SELECT * FROM tbl_client_project WHERE projectname LIKE '%".$keyword."%' ".$clients ;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function getProjectByGroup($groupId, $from, $to){
		$group = "SELECT id FROM tbl_user_group WHERE grp_id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") ";
		$project = "SELECT project_id FROM tbl_project_activities WHERE id IN (".$dprecords.") GROUP BY project_id";
		$txt = "SELECT * FROM tbl_client_project WHERE id IN (".$project.")";
		
		/*$txt = "SELECT tcp.* FROM tbl_client_project as tcp, tbl_project_activities as tpa, tbl_user_group as tug, tbl_group_access as tga,
		 	tbl_dpr_transaction as tdt, tbl_dprecords as td WHERE tpa.id = td.activity AND td.trans_id = tdt.id AND
		 	 DATE(tdt.date) >= '".$from."' AND DATE(tdt.date) <= '".$to."' AND tdt.status = 'done' AND tdt.user_id = tga.user_id
		 	  AND tga.group_id = tug.id AND tug.grp_id = '".$groupId."' AND tcp.id = tpa.project_id ";*/
		
		$txt = "
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tcp.id = tpa.project_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tdt.user_id
				INNER JOIN tbl_group_access tua ON tua.user_id = u.id
				
				WHERE
				
				tua.group_id = ".$groupId." AND 
				DATE(tdt.date) >= '".$from."' AND 
				( tdt.status = 'done' OR tdt.status = 'posted' ) AND 
				DATE(tdt.date) <= '".$to."' 
				
				GROUP BY tcp.id
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}

	static function getProjectByGroupClient($groupId, $from, $to, $clientId){
		$group = "SELECT id FROM tbl_user_group WHERE grp_id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") ";
		$project = "SELECT project_id FROM tbl_project_activities WHERE id IN (".$dprecords.")";
		$txt = "SELECT * FROM tbl_client_project WHERE id IN (".$project.") AND client_id = ".$clientId." ";
		
		
		$txt = "
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tcp.id = tpa.project_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tdt.user_id
				INNER JOIN tbl_group_access tua ON tua.user_id = u.id
				
				WHERE
				
				tua.group_id = ".$groupId." AND 
				DATE(tdt.date) >= '".$from."' AND 
				DATE(tdt.date) <= '".$to."' AND 
				( tdt.status = 'done' OR tdt.status = 'posted' ) AND 
				u.company = ".$clientId." 
				
				GROUP BY tcp.id
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function projectNameExist($projectName, $pId){
		
		$query2 = "SELECT * FROM tbl_client_project WHERE projectname = ? AND id != ? ;";
		$sqlQuery2 = new SqlQuery($query2);
		$sqlQuery2->setString($projectName);
		$sqlQuery2->set($pId);
		
		$tab = QueryExecutor::execute($sqlQuery2);
		if(empty($tab)){
			return false;
		} else {
			return true;
		}
	}
	
	static function getProjectByUser($userId, $search = '',$company=''){
		$find = $search != '' ? " AND projectname   LIKE '%".$search."%' " : "";
		$cmpny = $company != '' ? " AND cl.client_name  = '".$company."' " : "";
		$date = date('Y-m-d');
		$groupAccess = "SELECT group_id FROM tbl_group_access WHERE user_id = ".$userId." ";
		$txt = "SELECT cp.*,cl.client_name from tbl_client_project as cp 
							LEFT JOIN tbl_client as cl ON cp.`client_id` = cl.`id` 
								WHERE grp_id IN ( ".$groupAccess." ) ".$find.$cmpny." 
								AND status ='In Process'
								AND
									DATE(cp.estimated_end) >= '".$date."'
								
								
							;";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function getProjectUsed($start,$end,$group,$company){
		$txt = '
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tpa.project_id = tcp.id 
				INNER JOIN tbl_plan_records tpr ON tpr.activity = tpa.id
				INNER JOIN tbl_plan_transaction tpt ON tpt.id = tpr.trans_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tpt.user_id
				
				WHERE 
				
				((tdt.date >= "'.$start.'" AND tdt.date <= "'.$end.'") OR
				(tpt.from_date >= "'.$start.'" AND tpt.to_date <= "'.$end.'"))

				AND tcp.grp_id IN ('.$group.')
				AND u.company = '.$company.'
				GROUP BY tcp.id ORDER BY tcp.id
		';
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function getProjectUsedByUser($start,$end,$user){
		
		$txt = '
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tpa.project_id = tcp.id 
				INNER JOIN tbl_plan_records tpr ON tpr.activity = tpa.id
				INNER JOIN tbl_plan_transaction tpt ON tpt.id = tpr.trans_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				
				WHERE 
				
				((tdt.date >= "'.$start.'" AND tdt.date <= "'.$end.'") OR
				(tpt.from_date >= "'.$start.'" AND tpt.to_date <= "'.$end.'"))

				/*AND tcp.grp_id IN ('.$user.')*/
				AND tdt.user_id IN ('.$user.')
				AND tpt.user_id IN ('.$user.')
				
				GROUP BY tcp.id ORDER BY tcp.id
		';
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function projectIdExist($projectId, $pId){
		$query1 = "SELECT * FROM tbl_client_project WHERE project_id = '".$projectId."' AND id != ".$pId." ;";
		$sqlQuery1 = new SqlQuery($query1);
		
		$tab = QueryExecutor::execute($sqlQuery1);
		if(empty($tab)){
			return false;
		} else {
			return true;
		}
	}
	
	protected static function getProjectClient($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblClientProject();
			$result->id = $each['id'];
			$result->clientId = $each['client_id'];
			$result->projectId = $each['project_id'];
			$result->projectname = $each['projectname'];
			$result->costCenter = $each['cost_center'];
			$result->department = $each['department'];
			$result->grpId = $each['grp_id'];
			$result->type = $each['type'];
			$result->status = $each['status'];
			$results[] = $result;
		}
		return $results;
	}
	
	function getProjectSortByName($department)
	{
		 $sql = "SELECT * FROM tbl_client_project 
					WHERE department = ".$department." ORDER BY projectname ASC";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getLastId()
	{
		$sql = "SELECT max(id) as `id` FROM tbl_client_project";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	static function getProjectFilterByBudget($userId, $search = '',$company=''){
		$find = $search != '' ? " AND projectname   LIKE '%".$search."%' " : "";
		$cmpny = $company != '' ? " AND cl.client_name  = '".$company."' " : "";
		$date = date('Y-m-d');
		$groupAccess = "SELECT group_id FROM tbl_group_access WHERE user_id = ".$userId." ";
		$txt = "SELECT cp.*,cl.client_name from tbl_client_project as cp 
							LEFT JOIN tbl_client as cl ON cp.`client_id` = cl.`id` 
								WHERE grp_id IN ( ".$groupAccess." ) ".$find.$cmpny." 
								AND status ='In Process'
								AND
									DATE(cp.estimated_end) >= '".$date."'
								
								
							;";
		$sqlQuery = new SqlQuery($txt);
		return QueryExecutor::execute($sqlQuery);
	}
	
	static function getRecords($id)
	{
		while(true)
		{
			try
			{
				$query = "SELECT * from project_budget_variance WHERE id = ".$id." ";
				$sqlQuery = new SqlQuery($query);
				$recall = QueryExecutor::execute($sqlQuery);
				break;
			}
			catch(Exception $x)
			{
				$query = "CREATE VIEW project_budget_variance as
									(
											
											SELECT 
												tcp.id,
													tcp.projectname,
													(SUM(tcp.budget_hrs)/COUNT(tcp.id)) budget_hrs,
													 (SUM(tcp.partner_budget)/COUNT(tcp.id)) partner_budget,
													 (SUM(tcp.manager_budget)/COUNT(tcp.id)) manager_budget,
													 (SUM(tcp.snr_manager_budget)/COUNT(tcp.id)) snr_manager_budget,
													 (SUM(tcp.jr_manager_budget)/COUNT(tcp.id)) jr_manager_budget,
													 (SUM(tcp.supervisor_budget)/COUNT(tcp.id)) supervisor_budget,
													 (SUM(tcp.senior_budget)/COUNT(tcp.id)) senior_budget,
													 (SUM(tcp.staff_budget)/COUNT(tcp.id)) staff_budget,
															(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																	LEFT JOIN tbl_dprecords tdr
																			ON tdr.trans_id = tdt.id
                                                    LEFT JOIN tbl_project_activities tpa ON tpa.id = tdr.activity
													 WHERE
																	tdt.status = 'done'
															AND
																	tpa.project_id = tcp.id
													) hrs_spent,
											
													((SUM(tcp.budget_hrs)/COUNT(tcp.id)) -
													(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																	LEFT JOIN tbl_dprecords tdr
																			ON tdr.trans_id = tdt.id
																	LEFT JOIN tbl_project_activities tpa ON tpa.id = tdr.activity
																	 WHERE
																					tdt.status = 'done'
																			AND
																					tpa.project_id = tcp.id
													) )variance,
											
											
													(SUM(tcp.staff_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Staff'
														)
													) staff_variance,
                                                    
                                                    
                                                    (SUM(tcp.senior_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Senior'
														)
													) senior_variance,

(SUM(tcp.supervisor_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Supervisor'
														)
													) supervisor_variance,
                                                    
                                                    (SUM(tcp.snr_manager_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Snr. Manager'
														)
													) snr_manager_variance,
                                                     (SUM(tcp.jr_manager_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Jr. Manager'
														)
													) jr_manager_variance,
                                                     (SUM(tcp.manager_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Manager'
														)
													) manager_variance,
                                                     (SUM(tcp.partner_budget)/COUNT(tcp.id) - 
														(SELECT IFNULL(SUM(tdr.hour_spent),0) hrs_spent FROM tbl_dpr_transaction tdt
																		LEFT JOIN tbl_dprecords tdr
																				ON tdr.trans_id = tdt.id
																		LEFT JOIN tbl_project_activities tpa 
																				ON tpa.id = tdr.activity
																		LEFT JOIN tbl_user tu
																			ON tu.id = tdt.user_id
																		 WHERE
																						tdt.status = 'done'
																				AND
																						tpa.project_id = tcp.id
																				AND
																						tu.category = 'Partner'
														)
													) partner_variance
													
													
													
													
													
													FROM 
															tbl_client_project tcp
													LEFT JOIN tbl_project_activities tpa
															ON tpa.project_id = tcp.id
											WHERE
															DATE(tcp.estimated_end) >= '2016-09-01'
													AND
															status = 'In Process'
													AND
															tcp.budget_hrs > 0
											
											GROUP BY tcp.id
									);
							";
				$sqlQuery = new SqlQuery($query);
				QueryExecutor::executeUpdate($sqlQuery);
				
			}
		}
		return $recall;
		
	}
	
	function getUserClients($user)
	{
		$date = date('Y-m-d');
	
		$sql = "SELECT tcp.*,cc.name FROM `tbl_group_access` tga
					LEFT JOIN tbl_client_project tcp
						ON tcp.grp_id = tga.group_id
					LEFT JOIN cl_clients cc
						ON cc.id = tcp.cl_client
						
					  WHERE
								tga.user_id = {$user}
							AND
								tcp.status = 'In Process'
							AND
								tcp.budget_hrs > 0
							AND
								'{$date}' BETWEEN DATE(tcp.date_start) AND DATE(tcp.estimated_end)
						ORDER BY tcp.projectname ASC
					";
								
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function projectProfitabilitySummary()
	{
		$groupId = isset($_GET['groupId']) ? $_GET['groupId'] : 0;
		$from = isset($_GET['from']) ? date('Y-m-d',strtotime($_GET['from'])) : date('Y-m-d');
		$to = isset($_GET['to']) ? date('Y-m-d',strtotime($_GET['to'])) : date('Y-m-d');
	
		$sql = "SELECT tcp.id,tcp.projectname,tcp.contract_price,
				(SELECT (SUM(tdr.hour_spent) * (SELECT tpr.rates FROM tbl_position_rate tpr WHERE tpr.position = tu.category))
					FROM `tbl_dpr_transaction` tdt
						LEFT JOIN tbl_dprecords tdr
							ON tdr.trans_id = tdt.id
						LEFT JOIN tbl_user tu
							ON tu.id = tdt.user_id
						LEFT JOIN tbl_project_activities tpa
							ON tpa.id = tdr.activity
						WHERE
								tdt.status = 'done'
							AND
								tpa.project_id = tcp.id
							AND
								(tdt.date BETWEEN DATE(tcp.date_start) AND '{$to}')
								 
						  GROUP BY tpa.project_id
						   ) billing_rate,
						   
				(SELECT SUM(tdr.hour_spent) 
					FROM `tbl_dpr_transaction` tdt
						LEFT JOIN tbl_dprecords tdr
							ON tdr.trans_id = tdt.id
						LEFT JOIN tbl_user tu
							ON tu.id = tdt.user_id
						LEFT JOIN tbl_project_activities tpa
							ON tpa.id = tdr.activity
						WHERE
								tdt.status = 'done'
							AND
								tpa.project_id = tcp.id
							AND
								(tdt.date BETWEEN DATE(tcp.date_start) AND '{$to}')
								 
						  GROUP BY tpa.project_id
						   ) actual_hours


					FROM `tbl_client_project`  tcp
						LEFT JOIN tbl_project_activities tpa
							ON tpa.project_id = tcp.id

					WHERE
							tcp.`grp_id` = {$groupId}
						AND
							tcp.status != 'finished'
						
						AND tcp.contract_price > 0
				GROUP BY tcp.id
				ORDER BY tcp.projectname ASC
				
				
				
		";
		
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function getActualBillingPerPosition($position,$projectId,$from,$to)
	{
		$sql = "SELECT SUM(tdr.hour_spent) actual_hours
				FROM `tbl_dpr_transaction` tdt
					LEFT JOIN tbl_dprecords tdr
						ON tdr.trans_id = tdt.id
					LEFT JOIN tbl_user tu
						ON tu.id = tdt.user_id
					LEFT JOIN tbl_project_activities tpa
						ON tpa.id = tdr.activity
					LEFT JOIN tbl_client_project tcp
						ON tcp.id = tpa.project_id
					
					WHERE
						tdt.status = 'done'
							AND
						tpa.project_id = {$projectId}
							AND
						(tdt.date BETWEEN DATE(tcp.date_start) AND '{$to}')
						AND
							tu.category = '{$position}'

					GROUP BY tpa.project_id";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

	
}
?>