<?php
/**
 * Class that operate on table 'cl_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class ClTransactionMySqlDAO implements ClTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ClTransactionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM cl_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM cl_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM cl_transaction ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param clTransaction primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM cl_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ClTransactionMySql clTransaction
 	 */
	public function insert($clTransaction){
		$sql = 'INSERT INTO cl_transaction (client_id, date, satisfaction, customer, price, value, service, comment, date_submit, status, sender) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($clTransaction->clientId);
		$sqlQuery->set($clTransaction->date);
		$sqlQuery->set($clTransaction->satisfaction);
		$sqlQuery->set($clTransaction->customer);
		$sqlQuery->set($clTransaction->price);
		$sqlQuery->set($clTransaction->value);
		$sqlQuery->set($clTransaction->service);
		$sqlQuery->set($clTransaction->comment);
		$sqlQuery->set($clTransaction->dateSubmit);
		$sqlQuery->set($clTransaction->status);
		$sqlQuery->set($clTransaction->sender);

		$id = $this->executeInsert($sqlQuery);	
		$clTransaction->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ClTransactionMySql clTransaction
 	 */
	public function update($clTransaction){
		$sql = 'UPDATE cl_transaction SET client_id = ?, date = ?, satisfaction = ?, customer = ?, price = ?, value = ?, service = ?, comment = ?, date_submit = ?, status = ?, sender = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($clTransaction->clientId);
		$sqlQuery->set($clTransaction->date);
		$sqlQuery->set($clTransaction->satisfaction);
		$sqlQuery->set($clTransaction->customer);
		$sqlQuery->set($clTransaction->price);
		$sqlQuery->set($clTransaction->value);
		$sqlQuery->set($clTransaction->service);
		$sqlQuery->set($clTransaction->comment);
		$sqlQuery->set($clTransaction->dateSubmit);
		$sqlQuery->set($clTransaction->status);
		$sqlQuery->set($clTransaction->sender);

		$sqlQuery->setNumber($clTransaction->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM cl_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM cl_transaction WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM cl_transaction WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySatisfaction($value){
		$sql = 'SELECT * FROM cl_transaction WHERE satisfaction = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCustomer($value){
		$sql = 'SELECT * FROM cl_transaction WHERE customer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPrice($value){
		$sql = 'SELECT * FROM cl_transaction WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByValue($value){
		$sql = 'SELECT * FROM cl_transaction WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByService($value){
		$sql = 'SELECT * FROM cl_transaction WHERE service = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM cl_transaction WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateSubmit($value){
		$sql = 'SELECT * FROM cl_transaction WHERE date_submit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM cl_transaction WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySender($value){
		$sql = 'SELECT * FROM cl_transaction WHERE sender = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientId($value){
		$sql = 'DELETE FROM cl_transaction WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM cl_transaction WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySatisfaction($value){
		$sql = 'DELETE FROM cl_transaction WHERE satisfaction = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCustomer($value){
		$sql = 'DELETE FROM cl_transaction WHERE customer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPrice($value){
		$sql = 'DELETE FROM cl_transaction WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByValue($value){
		$sql = 'DELETE FROM cl_transaction WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByService($value){
		$sql = 'DELETE FROM cl_transaction WHERE service = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM cl_transaction WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateSubmit($value){
		$sql = 'DELETE FROM cl_transaction WHERE date_submit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM cl_transaction WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySender($value){
		$sql = 'DELETE FROM cl_transaction WHERE sender = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ClTransactionMySql 
	 */
	protected function readRow($row){
		$clTransaction = new ClTransaction();
		
		$clTransaction->id = $row['id'];
		$clTransaction->clientId = $row['client_id'];
		$clTransaction->date = $row['date'];
		$clTransaction->satisfaction = $row['satisfaction'];
		$clTransaction->customer = $row['customer'];
		$clTransaction->price = $row['price'];
		$clTransaction->value = $row['value'];
		$clTransaction->service = $row['service'];
		$clTransaction->comment = $row['comment'];
		$clTransaction->dateSubmit = $row['date_submit'];
		$clTransaction->status = $row['status'];
		$clTransaction->sender = $row['sender'];

		return $clTransaction;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ClTransactionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>