<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblWprDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblWpr 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblWpr primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblWpr tblWpr
 	 */
	public function insert($tblWpr);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblWpr tblWpr
 	 */
	public function update($tblWpr);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByDate($value);

	public function queryByTransId($value);


	public function deleteByUserId($value);

	public function deleteByDate($value);

	public function deleteByTransId($value);


}
?>