<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblUserDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUser 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUser primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUser tblUser
 	 */
	public function insert($tblUser);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUser tblUser
 	 */
	public function update($tblUser);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompany($value);

	public function queryByCompanyId($value);

	public function queryByUsername($value);

	public function queryByPassword($value);

	public function queryByFirstname($value);

	public function queryByMidname($value);

	public function queryByLastname($value);

	public function queryByPosition($value);

	public function queryByEmail($value);

	public function queryByDateRegistered($value);

	public function queryByUserType($value);

	public function queryByUserStatus($value);

	public function queryByDepartment($value);

	public function queryByCostCenter($value);

	public function queryByCategory($value);

	public function queryByAssignedLocation($value);


	public function deleteByCompany($value);

	public function deleteByCompanyId($value);

	public function deleteByUsername($value);

	public function deleteByPassword($value);

	public function deleteByFirstname($value);

	public function deleteByMidname($value);

	public function deleteByLastname($value);

	public function deleteByPosition($value);

	public function deleteByEmail($value);

	public function deleteByDateRegistered($value);

	public function deleteByUserType($value);

	public function deleteByUserStatus($value);

	public function deleteByDepartment($value);

	public function deleteByCostCenter($value);

	public function deleteByCategory($value);

	public function deleteByAssignedLocation($value);


}
?>