<div class="box-standard">
	<div class="row">
		<div class="col-lg-6 col-sm-6">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> NBT Report</div>
		</div>		
	</div>	
</div>
<form method="post" id="nbt_report">
	<div class="box-standard">
		<div class="row mt-15">
			<div class="col-lg-12 text-left">
				<div class="col-lg-6">
					<div class="form-group">
						<div class="input-group">
							<span class="input-group-addon input-group-success"><i class="pe-7s-link pe-lg"></i></span>
						    <select class="form-control selectpicker" data-live-search="true" name="subdomain">
						    </select>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-12 text-left">
				<div class="col-lg-6">
					<div class="form-group">
						<div class="input-group">
							<span class="input-group-addon input-group-success">User:</span>
						    <select class="form-control selectpicker" data-live-search="true" name="user">
						    </select>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-15">
			<div class="col-lg-8 text-left">
				<div class="col-lg-6">
					<div class="form-group">
						<div class="input-group">
						    <span class="input-group-addon input-group-success">Date:</span>
						    <input id="date" type="text" class="form-control datepicker" name="date" value="" required="">
						</div>
					</div>
				</div>
			<!-- 	<div class="col-lg-6">
					<div class="form-group">
						<div class="input-group">
						    <span class="input-group-addon input-group-success">To:</span>
						    <input id="to" type="text" class="form-control datepicker" name="to" value="" required="">
						</div>
					</div>
				</div> -->
			</div>
			<div class="col-lg-4 text-right">
				<div class="form-group">
					<div class="col-lg-12">
						<div class="page-header-buttons-standard-left">
							<button type="button" class="btn btn-success btn-pad btnGenerate"><i class="pe-7s-refresh-2 pe-lg"></i> Generate</button>
							<button type="button" class="btn btn-success btn-pad btnExport"><i class="pe-7s-download pe-lg"></i> Export</button>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-15">
			<div class="col-lg-12">
				<hr>
				<div class="wrap">
					<div class="table-responsive table-nbt">
						
					</div>
				</div>
			</div>		
		</div>
	</div>
</form>
<script>
	$(function(){
		getSubdomain();

		$('select[name=subdomain]').change(function(){

			id = $(this).val();
			
			$.post(URL +'reports/getUserPerSubdomain',{'subdomain':id})
			.done(function(returnData){

				data = $.parseJSON(returnData);
				append ='<option></option>';

				$.each(data, function(key,a){

					append += "<option value="+a.id+">"+a.name+"</option>";
					
				});

			$('select[name=user]').html(append);
			$('select[name=user]').selectpicker('refresh');
			})
		
		});

		$(".btnGenerate").click(function(){

			userId = $('select[name=user]').val();
			date = $('input[name="date"]').val();

			$.post(URL +'reports/getNbtReport',{'userId':userId, 'date':date})
			.done(function(returnData){

				$('.table-nbt').html(returnData);

			});
			
		});

		$('.btnExport').click(function(){
			userId = $('select[name=user]').val();
			date = $('input[name="date"]').val();

			window.location = URL +"export/nbtReport?userId="+userId+"&date="+date;

		});
});

function getSubdomain(){
		
	$.post(URL + 'employee/showSubdomains')
	.done(function(returnData){
		var data = $.parseJSON(returnData);

		var append = '<option></option>';
		$.each(data,function(key,a){
			append +=  '<option value="'+a.id+'">'+a.subdomain+'</option>';
		})
		$('select[name=subdomain]').html(append);
		$('select[name=subdomain]').selectpicker('refresh');
	});


}

</script>